/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import dev.mccue.jsr305.CheckForNull;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

@ElementTypesAreNonnullByDefault
public final class Closeables {
    static final System.Logger logger = System.getLogger(Closeables.class.getName());

    private Closeables() {
    }

    public static void close(@CheckForNull Closeable closeable, boolean swallowIOException) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            if (swallowIOException) {
                logger.log(System.Logger.Level.WARNING, "IOException thrown while closing Closeable.", (Throwable)e);
            }
            throw e;
        }
    }

    public static void closeQuietly(@CheckForNull InputStream inputStream) {
        try {
            Closeables.close(inputStream, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static void closeQuietly(@CheckForNull Reader reader) {
        try {
            Closeables.close(reader, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }
}

