/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.graph;

import dev.mccue.guava.collect.BiMap;
import dev.mccue.guava.collect.HashBiMap;
import dev.mccue.guava.collect.ImmutableBiMap;
import dev.mccue.guava.graph.AbstractUndirectedNetworkConnections;
import dev.mccue.guava.graph.EdgesConnecting;
import dev.mccue.guava.graph.ElementTypesAreNonnullByDefault;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections<N, E>(HashBiMap.create((int)2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

