/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.collect;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.collect.ImmutableList;
import dev.mccue.guava.collect.ImmutableSet;
import dev.mccue.guava.collect.Iterators;
import dev.mccue.guava.collect.UnmodifiableIterator;
import dev.mccue.jsr305.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return "[" + this.element.toString() + "]";
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }
}

