/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.collect;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.collect.ImmutableList;
import dev.mccue.guava.collect.Iterators;
import dev.mccue.guava.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Spliterator;

@ElementTypesAreNonnullByDefault
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex((int)index, (int)1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes((int)fromIndex, (int)toIndex, (int)1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        return "[" + this.element.toString() + "]";
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }
}

