/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.version;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.empty.EmptyResponse;
import masecla.modrinth4j.endpoints.version.AddFilesToVersion;
import masecla.modrinth4j.endpoints.version.CreateVersion;
import masecla.modrinth4j.endpoints.version.DeleteVersion;
import masecla.modrinth4j.endpoints.version.GetProjectVersions;
import masecla.modrinth4j.endpoints.version.GetVersion;
import masecla.modrinth4j.endpoints.version.GetVersionByVersionNumber;
import masecla.modrinth4j.endpoints.version.GetVersions;
import masecla.modrinth4j.endpoints.version.ModifyVersion;
import masecla.modrinth4j.endpoints.version.files.VersionFilesEndpoints;
import masecla.modrinth4j.model.version.ProjectVersion;

public class VersionEndpoints {
    private Gson gson;
    private HttpClient httpClient;

    public VersionFilesEndpoints files() {
        return new VersionFilesEndpoints(this.gson, this.httpClient);
    }

    public CompletableFuture<List<ProjectVersion>> getProjectVersions(String slug, GetProjectVersions.GetProjectVersionsRequest requestObject) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new GetProjectVersions(this.httpClient, this.gson).sendRequest(requestObject, parameters);
    }

    public CompletableFuture<ProjectVersion> getVersion(String versionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", versionId);
        return new GetVersion(this.httpClient, this.gson).sendRequest(null, parameters);
    }

    public CompletableFuture<ProjectVersion> getVersionByNumber(String projectSlug, String versionNumber) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("slug", projectSlug);
        parameters.put("versionNumber", versionNumber);
        return new GetVersionByVersionNumber(this.httpClient, this.gson).sendRequest(null, parameters);
    }

    public CompletableFuture<List<ProjectVersion>> getVersion(List<String> versionIds) {
        return new GetVersions(this.httpClient, this.gson).sendRequest(new GetVersions.GetVersionsRequest(versionIds));
    }

    public CompletableFuture<List<ProjectVersion>> getVersion(String ... versionIds) {
        return this.getVersion(Arrays.asList(versionIds));
    }

    public CompletableFuture<ProjectVersion> modifyProjectVersion(String versionId, ModifyVersion.ModifyVersionRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", versionId);
        return new ModifyVersion(this.httpClient, this.gson).sendRequest(request, parameters);
    }

    public CompletableFuture<EmptyResponse> deleteProjectVersion(String versionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", versionId);
        return new DeleteVersion(this.httpClient, this.gson).sendRequest(null, parameters);
    }

    public CompletableFuture<ProjectVersion> createProjectVersion(CreateVersion.CreateVersionRequest request) {
        return new CreateVersion(this.httpClient, this.gson).sendRequest(request);
    }

    public CompletableFuture<EmptyResponse> addFilesToVersion(String versionId, Map<String, InputStream> files) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", versionId);
        return new AddFilesToVersion(this.httpClient, this.gson).sendRequest(files, (Map<String, String>)parameters);
    }

    public CompletableFuture<EmptyResponse> addFilesToVersion(String versionId, List<File> files) throws FileNotFoundException {
        HashMap<String, InputStream> fileMap = new HashMap<String, InputStream>();
        for (File file : files) {
            fileMap.put(file.getName(), new FileInputStream(file));
        }
        return this.addFilesToVersion(versionId, fileMap);
    }

    @Generated
    public VersionEndpoints(Gson gson, HttpClient httpClient) {
        this.gson = gson;
        this.httpClient = httpClient;
    }
}

