/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.blas;

import dev.ludovic.netlib.blas.BLAS;
import dev.ludovic.netlib.blas.JNIBLAS;
import dev.ludovic.netlib.blas.Java11BLAS;
import dev.ludovic.netlib.blas.Java8BLAS;
import dev.ludovic.netlib.blas.JavaBLAS;
import dev.ludovic.netlib.blas.NativeBLAS;
import dev.ludovic.netlib.blas.VectorBLAS;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final BLAS blas = InstanceBuilder.getInstanceImpl();
    private static final NativeBLAS nativeBlas = InstanceBuilder.getNativeInstanceImpl();
    private static final JavaBLAS javaBlas = InstanceBuilder.getJavaInstanceImpl();

    InstanceBuilder() {
    }

    public static BLAS getInstance() {
        return blas;
    }

    private static BLAS getInstanceImpl() {
        try {
            return NativeBLAS.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + NativeBLAS.class.getName());
            return JavaBLAS.getInstance();
        }
    }

    public static NativeBLAS getNativeInstance() {
        return nativeBlas;
    }

    private static NativeBLAS getNativeInstanceImpl() {
        try {
            return JNIBLAS.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + JNIBLAS.class.getName());
            throw new RuntimeException("Unable to load native implementation");
        }
    }

    public static JavaBLAS getJavaInstance() {
        return javaBlas;
    }

    private static JavaBLAS getJavaInstanceImpl() {
        String[] fullVersion = System.getProperty("java.version").split("[+.\\-]+", 2);
        int major = Integer.parseInt(fullVersion[0]);
        if (major >= 16) {
            try {
                return VectorBLAS.getInstance();
            }
            catch (Throwable t) {
                log.warning("Failed to load implementation from:" + VectorBLAS.class.getName());
            }
        }
        if (major >= 11) {
            return Java11BLAS.getInstance();
        }
        return Java8BLAS.getInstance();
    }
}

