/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.blas;

import dev.ludovic.netlib.BLAS;
import java.util.Objects;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;

abstract class AbstractBLAS
implements BLAS {
    AbstractBLAS() {
    }

    protected int loopAlign(int index, int max, int size) {
        return Math.min(this.loopBound(index + size - 1, size), max);
    }

    protected int loopBound(int index, int size) {
        return index - index % size;
    }

    private void checkArgument(String method, int arg, boolean check) {
        if (!check) {
            throw new IllegalArgumentException(String.format("** On entry to '%s' parameter number %d had an illegal value", method, arg));
        }
    }

    private void checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException(index);
        }
    }

    @Override
    public double dasum(int n, double[] x, int incx) {
        return this.dasum(n, x, 0, incx);
    }

    @Override
    public double dasum(int n, double[] x, int offsetx, int incx) {
        if (n <= 0) {
            return 0.0;
        }
        Objects.requireNonNull(x);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        return this.dasumK(n, x, offsetx, incx);
    }

    protected abstract double dasumK(int var1, double[] var2, int var3, int var4);

    @Override
    public float sasum(int n, float[] x, int incx) {
        return this.sasum(n, x, 0, incx);
    }

    @Override
    public float sasum(int n, float[] x, int offsetx, int incx) {
        if (n <= 0) {
            return 0.0f;
        }
        Objects.requireNonNull(x);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        return this.sasumK(n, x, offsetx, incx);
    }

    protected abstract float sasumK(int var1, float[] var2, int var3, int var4);

    @Override
    public void daxpy(int n, double alpha, double[] x, int incx, double[] y, int incy) {
        this.daxpy(n, alpha, x, 0, incx, y, 0, incy);
    }

    @Override
    public void daxpy(int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        if (n <= 0) {
            return;
        }
        if (alpha == 0.0) {
            return;
        }
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        this.checkIndex(offsety + (n - 1) * Math.abs(incy), y.length);
        this.daxpyK(n, alpha, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract void daxpyK(int var1, double var2, double[] var4, int var5, int var6, double[] var7, int var8, int var9);

    @Override
    public void saxpy(int n, float alpha, float[] x, int incx, float[] y, int incy) {
        this.saxpy(n, alpha, x, 0, incx, y, 0, incy);
    }

    @Override
    public void saxpy(int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        if (n <= 0) {
            return;
        }
        if (alpha == 0.0f) {
            return;
        }
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        this.checkIndex(offsety + (n - 1) * Math.abs(incy), y.length);
        this.saxpyK(n, alpha, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract void saxpyK(int var1, float var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8);

    @Override
    public void dcopy(int n, double[] x, int incx, double[] y, int incy) {
        this.dcopy(n, x, 0, incx, y, 0, incy);
    }

    @Override
    public void dcopy(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        if (n <= 0) {
            return;
        }
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        this.checkIndex(offsety + (n - 1) * Math.abs(incy), y.length);
        this.dcopyK(n, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract void dcopyK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    @Override
    public void scopy(int n, float[] x, int incx, float[] y, int incy) {
        this.scopy(n, x, 0, incx, y, 0, incy);
    }

    @Override
    public void scopy(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        if (n <= 0) {
            return;
        }
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        this.checkIndex(offsety + (n - 1) * Math.abs(incy), y.length);
        this.scopyK(n, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract void scopyK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    @Override
    public double ddot(int n, double[] x, int incx, double[] y, int incy) {
        return this.ddot(n, x, 0, incx, y, 0, incy);
    }

    @Override
    public double ddot(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        if (n <= 0) {
            return 0.0;
        }
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        this.checkIndex(offsety + (n - 1) * Math.abs(incy), y.length);
        return this.ddotK(n, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract double ddotK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    @Override
    public float sdot(int n, float[] x, int incx, float[] y, int incy) {
        return this.sdot(n, x, 0, incx, y, 0, incy);
    }

    @Override
    public float sdot(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        if (n <= 0) {
            return 0.0f;
        }
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        this.checkIndex(offsetx + (n - 1) * Math.abs(incx), x.length);
        this.checkIndex(offsety + (n - 1) * Math.abs(incy), y.length);
        return this.sdotK(n, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract float sdotK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    @Override
    public float sdsdot(int n, float sb, float[] x, int incx, float[] y, int incy) {
        return this.sdsdot(n, sb, x, 0, incx, y, 0, incy);
    }

    @Override
    public float sdsdot(int n, float sb, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        if (n <= 0) {
            return 0.0f;
        }
        return this.sdsdotK(n, sb, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract float sdsdotK(int var1, float var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8);

    @Override
    public void dgbmv(String trans, int m, int n, int kl, int ku, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dgbmv(trans, m, n, kl, ku, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void dgbmv(String trans, int m, int n, int kl, int ku, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.dgbmvK(trans, m, n, kl, ku, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void dgbmvK(String var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18);

    @Override
    public void sgbmv(String trans, int m, int n, int kl, int ku, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        this.sgbmv(trans, m, n, kl, ku, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void sgbmv(String trans, int m, int n, int kl, int ku, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.sgbmvK(trans, m, n, kl, ku, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void sgbmvK(String var1, int var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16);

    @Override
    public void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        this.dgemm(transa, transb, m, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    @Override
    public void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb, double beta, double[] c, int offsetc, int ldc) {
        this.checkArgument("DGEMM", 1, this.lsame("T", transa) || this.lsame("N", transa) || this.lsame("C", transa));
        this.checkArgument("DGEMM", 2, this.lsame("T", transb) || this.lsame("N", transb) || this.lsame("C", transb));
        this.checkArgument("DGEMM", 3, m >= 0);
        this.checkArgument("DGEMM", 4, n >= 0);
        this.checkArgument("DGEMM", 5, k >= 0);
        this.checkArgument("DGEMM", 8, lda >= Math.max(1, this.lsame("N", transa) ? m : k));
        this.checkArgument("DGEMM", 10, ldb >= Math.max(1, this.lsame("N", transb) ? k : n));
        this.checkArgument("DGEMM", 13, ldc >= Math.max(1, m));
        if (m == 0 || n == 0 || (alpha == 0.0 || k == 0) && beta == 1.0) {
            return;
        }
        this.dgemmK(transa, transb, m, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    protected abstract void dgemmK(String var1, String var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18);

    @Override
    public void sgemm(String transa, String transb, int m, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int ldc) {
        this.sgemm(transa, transb, m, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    @Override
    public void sgemm(String transa, String transb, int m, int n, int k, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb, float beta, float[] c, int offsetc, int ldc) {
        this.checkArgument("SGEMM", 1, this.lsame("T", transa) || this.lsame("N", transa) || this.lsame("C", transa));
        this.checkArgument("SGEMM", 2, this.lsame("T", transb) || this.lsame("N", transb) || this.lsame("C", transb));
        this.checkArgument("SGEMM", 3, m >= 0);
        this.checkArgument("SGEMM", 4, n >= 0);
        this.checkArgument("SGEMM", 5, k >= 0);
        this.checkArgument("SGEMM", 8, lda >= Math.max(1, this.lsame("N", transa) ? m : k));
        this.checkArgument("SGEMM", 10, ldb >= Math.max(1, this.lsame("N", transb) ? k : n));
        this.checkArgument("SGEMM", 13, ldc >= Math.max(1, m));
        if (m == 0 || n == 0 || (alpha == 0.0f || k == 0) && beta == 1.0f) {
            return;
        }
        this.sgemmK(transa, transb, m, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    protected abstract void sgemmK(String var1, String var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16);

    @Override
    public void dgemv(String trans, int m, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dgemv(trans, m, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void dgemv(String trans, int m, int n, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.checkArgument("DGEMV", 1, this.lsame("N", trans) || this.lsame("T", trans) || this.lsame("C", trans));
        this.checkArgument("DGEMV", 2, m >= 0);
        this.checkArgument("DGEMV", 3, n >= 0);
        this.checkArgument("DGEMV", 6, lda >= Math.max(1, m));
        this.checkArgument("DGEMV", 8, incx != 0);
        this.checkArgument("DGEMV", 11, incy != 0);
        if (m == 0 || n == 0) {
            return;
        }
        this.dgemvK(trans, m, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void dgemvK(String var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16);

    @Override
    public void sgemv(String trans, int m, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        this.sgemv(trans, m, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void sgemv(String trans, int m, int n, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.checkArgument("SGEMV", 1, this.lsame("N", trans) || this.lsame("T", trans) || this.lsame("C", trans));
        this.checkArgument("SGEMV", 2, m >= 0);
        this.checkArgument("SGEMV", 3, n >= 0);
        this.checkArgument("SGEMV", 6, lda >= Math.max(1, m));
        this.checkArgument("SGEMV", 8, incx != 0);
        this.checkArgument("SGEMV", 11, incy != 0);
        if (m == 0 || n == 0) {
            return;
        }
        this.sgemvK(trans, m, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void sgemvK(String var1, int var2, int var3, float var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float var11, float[] var12, int var13, int var14);

    @Override
    public void dger(int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda) {
        this.dger(m, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    @Override
    public void dger(int m, int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] a, int offseta, int lda) {
        this.checkArgument("DGER", 1, m >= 0);
        this.checkArgument("DGER", 2, n >= 0);
        this.checkArgument("DGER", 5, incx != 0);
        this.checkArgument("DGER", 7, incy != 0);
        this.checkArgument("DGER", 9, lda >= Math.max(1, m));
        if (m == 0 || n == 0) {
            return;
        }
        if (alpha != 0.0) {
            this.dgerK(m, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
        }
    }

    protected abstract void dgerK(int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    @Override
    public void sger(int m, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda) {
        this.sger(m, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    @Override
    public void sger(int m, int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] a, int offseta, int lda) {
        this.checkArgument("SGER", 1, m >= 0);
        this.checkArgument("SGER", 2, n >= 0);
        this.checkArgument("SGER", 5, incx != 0);
        this.checkArgument("SGER", 7, incy != 0);
        this.checkArgument("SGER", 9, lda >= Math.max(1, m));
        if (m == 0 || n == 0) {
            return;
        }
        if (alpha != 0.0f) {
            this.sgerK(m, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
        }
    }

    protected abstract void sgerK(int var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12);

    @Override
    public double dnrm2(int n, double[] x, int incx) {
        return this.dnrm2(n, x, 0, incx);
    }

    @Override
    public double dnrm2(int n, double[] x, int offsetx, int incx) {
        if (n <= 0) {
            return 0.0;
        }
        if (incx <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(x[offsetx + 0]);
        }
        return this.dnrm2K(n, x, offsetx, incx);
    }

    protected abstract double dnrm2K(int var1, double[] var2, int var3, int var4);

    @Override
    public float snrm2(int n, float[] x, int incx) {
        return this.snrm2(n, x, 0, incx);
    }

    @Override
    public float snrm2(int n, float[] x, int offsetx, int incx) {
        if (n <= 0) {
            return 0.0f;
        }
        if (incx <= 0) {
            return 0.0f;
        }
        if (n == 1) {
            return Math.abs(x[offsetx + 0]);
        }
        return this.snrm2K(n, x, offsetx, incx);
    }

    protected abstract float snrm2K(int var1, float[] var2, int var3, int var4);

    @Override
    public void drot(int n, double[] x, int incx, double[] y, int incy, double c, double s) {
        this.drot(n, x, 0, incx, y, 0, incy, c, s);
    }

    @Override
    public void drot(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double c, double s) {
        if (n <= 0) {
            return;
        }
        this.drotK(n, x, offsetx, incx, y, offsety, incy, c, s);
    }

    protected abstract void drotK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double var8, double var10);

    @Override
    public void srot(int n, float[] x, int incx, float[] y, int incy, float c, float s) {
        this.srot(n, x, 0, incx, y, 0, incy, c, s);
    }

    @Override
    public void srot(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float c, float s) {
        if (n <= 0) {
            return;
        }
        this.srotK(n, x, offsetx, incx, y, offsety, incy, c, s);
    }

    protected abstract void srotK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, float var8, float var9);

    @Override
    public void drotg(doubleW da, doubleW db, doubleW c, doubleW s) {
        double scale = Math.abs(da.val) + Math.abs(db.val);
        if (scale == 0.0) {
            c.val = 1.0;
            s.val = 0.0;
            da.val = 0.0;
            db.val = 0.0;
        } else {
            double r = scale * Math.sqrt(Math.pow(da.val / scale, 2.0) + Math.pow(db.val / scale, 2.0)) * ((Math.abs(da.val) > Math.abs(db.val) ? da.val : db.val) >= 0.0 ? 1.0 : -1.0);
            c.val = da.val / r;
            s.val = db.val / r;
            double z = 1.0;
            if (Math.abs(da.val) > Math.abs(db.val)) {
                z = s.val;
            } else if (c.val != 0.0) {
                z = 1.0 / c.val;
            }
            da.val = r;
            db.val = z;
        }
    }

    @Override
    public void srotg(floatW sa, floatW sb, floatW c, floatW s) {
        float scale = Math.abs(sa.val) + Math.abs(sb.val);
        if (scale == 0.0f) {
            c.val = 1.0f;
            s.val = 0.0f;
            sa.val = 0.0f;
            sb.val = 0.0f;
        } else {
            float r = (float)((double)scale * Math.sqrt(Math.pow(sa.val / scale, 2.0) + Math.pow(sb.val / scale, 2.0)) * ((Math.abs(sa.val) > Math.abs(sb.val) ? sa.val : sb.val) >= 0.0f ? 1.0 : -1.0));
            c.val = sa.val / r;
            s.val = sb.val / r;
            float z = 1.0f;
            if (Math.abs(sa.val) > Math.abs(sb.val)) {
                z = s.val;
            } else if (c.val != 0.0f) {
                z = 1.0f / c.val;
            }
            sa.val = r;
            sb.val = z;
        }
    }

    @Override
    public void drotm(int n, double[] x, int incx, double[] y, int incy, double[] param) {
        this.drotm(n, x, 0, incx, y, 0, incy, param, 0);
    }

    @Override
    public void drotm(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] param, int offsetparam) {
        this.drotmK(n, x, offsetx, incx, y, offsety, incy, param, offsetparam);
    }

    protected abstract void drotmK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9);

    @Override
    public void srotm(int n, float[] x, int incx, float[] y, int incy, float[] param) {
        this.srotm(n, x, 0, incx, y, 0, incy, param, 0);
    }

    @Override
    public void srotm(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] param, int offsetparam) {
        this.srotmK(n, x, offsetx, incx, y, offsety, incy, param, offsetparam);
    }

    protected abstract void srotmK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9);

    @Override
    public void drotmg(doubleW dd1, doubleW dd2, doubleW dx1, double dy1, double[] param) {
        this.drotmg(dd1, dd2, dx1, dy1, param, 0);
    }

    @Override
    public void drotmg(doubleW dd1, doubleW dd2, doubleW dx1, double dy1, double[] param, int offsetparam) {
        this.drotmgK(dd1, dd2, dx1, dy1, param, offsetparam);
    }

    protected abstract void drotmgK(doubleW var1, doubleW var2, doubleW var3, double var4, double[] var6, int var7);

    @Override
    public void srotmg(floatW sd1, floatW sd2, floatW sx1, float sy1, float[] param) {
        this.srotmg(sd1, sd2, sx1, sy1, param, 0);
    }

    @Override
    public void srotmg(floatW sd1, floatW sd2, floatW sx1, float sy1, float[] param, int offsetparam) {
        this.srotmgK(sd1, sd2, sx1, sy1, param, offsetparam);
    }

    protected abstract void srotmgK(floatW var1, floatW var2, floatW var3, float var4, float[] var5, int var6);

    @Override
    public void dsbmv(String uplo, int n, int k, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dsbmv(uplo, n, k, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void dsbmv(String uplo, int n, int k, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.dsbmvK(uplo, n, k, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void dsbmvK(String var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16);

    @Override
    public void ssbmv(String uplo, int n, int k, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        this.ssbmv(uplo, n, k, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void ssbmv(String uplo, int n, int k, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.ssbmvK(uplo, n, k, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void ssbmvK(String var1, int var2, int var3, float var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float var11, float[] var12, int var13, int var14);

    @Override
    public void dscal(int n, double alpha, double[] x, int incx) {
        this.dscal(n, alpha, x, 0, incx);
    }

    @Override
    public void dscal(int n, double alpha, double[] x, int offsetx, int incx) {
        if (n <= 0) {
            return;
        }
        if (incx <= 0) {
            return;
        }
        if (alpha == 1.0) {
            return;
        }
        this.dscalK(n, alpha, x, offsetx, incx);
    }

    protected abstract void dscalK(int var1, double var2, double[] var4, int var5, int var6);

    @Override
    public void sscal(int n, float alpha, float[] x, int incx) {
        this.sscal(n, alpha, x, 0, incx);
    }

    @Override
    public void sscal(int n, float alpha, float[] x, int offsetx, int incx) {
        if (n <= 0) {
            return;
        }
        if (incx <= 0) {
            return;
        }
        if (alpha == 1.0f) {
            return;
        }
        this.sscalK(n, alpha, x, offsetx, incx);
    }

    protected abstract void sscalK(int var1, float var2, float[] var3, int var4, int var5);

    @Override
    public void dspmv(String uplo, int n, double alpha, double[] a, double[] x, int incx, double beta, double[] y, int incy) {
        this.dspmv(uplo, n, alpha, a, 0, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void dspmv(String uplo, int n, double alpha, double[] a, int offseta, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.checkArgument("DSPMV", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSPMV", 2, n >= 0);
        this.checkArgument("DSPMV", 6, incx != 0);
        this.checkArgument("DSPMV", 9, incy != 0);
        if (n == 0) {
            return;
        }
        this.dspmvK(uplo, n, alpha, a, offseta, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void dspmvK(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14);

    @Override
    public void sspmv(String uplo, int n, float alpha, float[] a, float[] x, int incx, float beta, float[] y, int incy) {
        this.sspmv(uplo, n, alpha, a, 0, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void sspmv(String uplo, int n, float alpha, float[] a, int offseta, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.checkArgument("SSPMV", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSPMV", 2, n >= 0);
        this.checkArgument("SSPMV", 6, incx != 0);
        this.checkArgument("SSPMV", 9, incy != 0);
        if (n == 0) {
            return;
        }
        this.sspmvK(uplo, n, alpha, a, offseta, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void sspmvK(String var1, int var2, float var3, float[] var4, int var5, float[] var6, int var7, int var8, float var9, float[] var10, int var11, int var12);

    @Override
    public void dspr(String uplo, int n, double alpha, double[] x, int incx, double[] a) {
        this.dspr(uplo, n, alpha, x, 0, incx, a, 0);
    }

    @Override
    public void dspr(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] a, int offseta) {
        this.checkArgument("DSPR", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSPR", 2, n >= 0);
        this.checkArgument("DSPR", 5, incx != 0);
        if (n == 0) {
            return;
        }
        this.dsprK(uplo, n, alpha, x, offsetx, incx, a, offseta);
    }

    protected abstract void dsprK(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9);

    @Override
    public void sspr(String uplo, int n, float alpha, float[] x, int incx, float[] a) {
        this.sspr(uplo, n, alpha, x, 0, incx, a, 0);
    }

    @Override
    public void sspr(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] a, int offseta) {
        this.checkArgument("SSPR", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSPR", 2, n >= 0);
        this.checkArgument("SSPR", 5, incx != 0);
        if (n == 0) {
            return;
        }
        this.ssprK(uplo, n, alpha, x, offsetx, incx, a, offseta);
    }

    protected abstract void ssprK(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8);

    @Override
    public void dspr2(String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a) {
        this.dspr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0);
    }

    @Override
    public void dspr2(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] a, int offseta) {
        this.checkArgument("DSPR2", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSPR2", 2, n >= 0);
        this.checkArgument("DSPR2", 5, incx != 0);
        this.checkArgument("DSPR2", 7, incy != 0);
        if (n == 0) {
            return;
        }
        this.dspr2K(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta);
    }

    protected abstract void dspr2K(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12);

    @Override
    public void sspr2(String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a) {
        this.sspr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0);
    }

    @Override
    public void sspr2(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] a, int offseta) {
        this.checkArgument("SSPR2", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSPR2", 2, n >= 0);
        this.checkArgument("SSPR2", 5, incx != 0);
        this.checkArgument("SSPR2", 7, incy != 0);
        if (n == 0) {
            return;
        }
        this.sspr2K(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta);
    }

    protected abstract void sspr2K(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11);

    @Override
    public void dswap(int n, double[] x, int incx, double[] y, int incy) {
        this.dswap(n, x, 0, incx, y, 0, incy);
    }

    @Override
    public void dswap(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        if (n <= 0) {
            return;
        }
        this.dswapK(n, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract void dswapK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    @Override
    public void sswap(int n, float[] x, int incx, float[] y, int incy) {
        this.sswap(n, x, 0, incx, y, 0, incy);
    }

    @Override
    public void sswap(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        if (n <= 0) {
            return;
        }
        this.sswapK(n, x, offsetx, incx, y, offsety, incy);
    }

    protected abstract void sswapK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    @Override
    public void dsymm(String side, String uplo, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        this.dsymm(side, uplo, m, n, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    @Override
    public void dsymm(String side, String uplo, int m, int n, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb, double beta, double[] c, int offsetc, int ldc) {
        this.checkArgument("DSYMM", 1, this.lsame("L", side) || this.lsame("R", side));
        this.checkArgument("DSYMM", 2, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSYMM", 3, m >= 0);
        this.checkArgument("DSYMM", 4, n >= 0);
        this.checkArgument("DSYMM", 7, lda >= Math.max(1, this.lsame("L", side) ? m : n));
        this.checkArgument("DSYMM", 9, ldb >= Math.max(1, m));
        this.checkArgument("DSYMM", 12, ldc >= Math.max(1, m));
        if (m == 0 || n == 0 || alpha == 0.0 && beta == 1.0) {
            return;
        }
        this.dsymmK(side, uplo, m, n, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    protected abstract void dsymmK(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    @Override
    public void ssymm(String side, String uplo, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int ldc) {
        this.ssymm(side, uplo, m, n, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    @Override
    public void ssymm(String side, String uplo, int m, int n, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb, float beta, float[] c, int offsetc, int ldc) {
        this.checkArgument("SSYMM", 1, this.lsame("L", side) || this.lsame("R", side));
        this.checkArgument("SSYMM", 2, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSYMM", 3, m >= 0);
        this.checkArgument("SSYMM", 4, n >= 0);
        this.checkArgument("SSYMM", 7, lda >= Math.max(1, this.lsame("L", side) ? m : n));
        this.checkArgument("SSYMM", 9, ldb >= Math.max(1, m));
        this.checkArgument("SSYMM", 12, ldc >= Math.max(1, m));
        if (m == 0 || n == 0 || alpha == 0.0f && beta == 1.0f) {
            return;
        }
        this.ssymmK(side, uplo, m, n, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    protected abstract void ssymmK(String var1, String var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float[] var13, int var14, int var15);

    @Override
    public void dsymv(String uplo, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dsymv(uplo, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void dsymv(String uplo, int n, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.checkArgument("DSYMV", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSYMV", 2, n >= 0);
        this.checkArgument("DSYMV", 5, lda >= Math.max(1, n));
        this.checkArgument("DSYMV", 7, incx != 0);
        this.checkArgument("DSYMV", 10, incy != 0);
        if (n == 0) {
            return;
        }
        this.dsymvK(uplo, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void dsymvK(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double var11, double[] var13, int var14, int var15);

    @Override
    public void ssymv(String uplo, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        this.ssymv(uplo, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    @Override
    public void ssymv(String uplo, int n, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.checkArgument("SSYMV", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSYMV", 2, n >= 0);
        this.checkArgument("SSYMV", 5, lda >= Math.max(1, n));
        this.checkArgument("SSYMV", 7, incx != 0);
        this.checkArgument("SSYMV", 10, incy != 0);
        if (n == 0) {
            return;
        }
        this.ssymvK(uplo, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    protected abstract void ssymvK(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float var10, float[] var11, int var12, int var13);

    @Override
    public void dsyr(String uplo, int n, double alpha, double[] x, int incx, double[] a, int lda) {
        this.dsyr(uplo, n, alpha, x, 0, incx, a, 0, lda);
    }

    @Override
    public void dsyr(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] a, int offseta, int lda) {
        this.checkArgument("DSYR", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSYR", 2, n >= 0);
        this.checkArgument("DSYR", 5, incx != 0);
        this.checkArgument("DSYR", 7, lda >= Math.max(1, n));
        if (n == 0) {
            return;
        }
        this.dsyrK(uplo, n, alpha, x, offsetx, incx, a, offseta, lda);
    }

    protected abstract void dsyrK(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    public void ssyr(String uplo, int n, float alpha, float[] x, int incx, float[] a, int lda) {
        this.ssyr(uplo, n, alpha, x, 0, incx, a, 0, lda);
    }

    @Override
    public void ssyr(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] a, int offseta, int lda) {
        this.checkArgument("SSYR", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSYR", 2, n >= 0);
        this.checkArgument("SSYR", 5, incx != 0);
        this.checkArgument("SSYR", 7, lda >= Math.max(1, n));
        if (n == 0) {
            return;
        }
        this.ssyrK(uplo, n, alpha, x, offsetx, incx, a, offseta, lda);
    }

    protected abstract void ssyrK(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9);

    @Override
    public void dsyr2(String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda) {
        this.dsyr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    @Override
    public void dsyr2(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] a, int offseta, int lda) {
        this.checkArgument("DSYR2", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("DSYR2", 2, n >= 0);
        this.checkArgument("DSYR2", 5, incx != 0);
        this.checkArgument("DSYR2", 7, incy != 0);
        this.checkArgument("DSYR2", 9, lda >= Math.max(1, n));
        if (n == 0) {
            return;
        }
        this.dsyr2K(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
    }

    protected abstract void dsyr2K(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    @Override
    public void ssyr2(String uplo, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] a, int lda) {
        this.ssyr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    @Override
    public void ssyr2(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] a, int offseta, int lda) {
        this.checkArgument("SSYR2", 1, this.lsame("U", uplo) || this.lsame("L", uplo));
        this.checkArgument("SSYR2", 2, n >= 0);
        this.checkArgument("SSYR2", 5, incx != 0);
        this.checkArgument("SSYR2", 7, incy != 0);
        this.checkArgument("SSYR2", 9, lda >= Math.max(1, n));
        if (n == 0) {
            return;
        }
        this.ssyr2K(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
    }

    protected abstract void ssyr2K(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12);

    @Override
    public void dsyr2k(String uplo, String trans, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        this.dsyr2k(uplo, trans, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    @Override
    public void dsyr2k(String uplo, String trans, int n, int k, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb, double beta, double[] c, int offsetc, int ldc) {
        this.dsyr2kK(uplo, trans, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    protected abstract void dsyr2kK(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    @Override
    public void ssyr2k(String uplo, String trans, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int ldc) {
        this.ssyr2k(uplo, trans, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    @Override
    public void ssyr2k(String uplo, String trans, int n, int k, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb, float beta, float[] c, int offsetc, int ldc) {
        this.ssyr2kK(uplo, trans, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    protected abstract void ssyr2kK(String var1, String var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float[] var13, int var14, int var15);

    @Override
    public void dsyrk(String uplo, String trans, int n, int k, double alpha, double[] a, int lda, double beta, double[] c, int ldc) {
        this.dsyrk(uplo, trans, n, k, alpha, a, 0, lda, beta, c, 0, ldc);
    }

    @Override
    public void dsyrk(String uplo, String trans, int n, int k, double alpha, double[] a, int offseta, int lda, double beta, double[] c, int offsetc, int ldc) {
        this.dsyrkK(uplo, trans, n, k, alpha, a, offseta, lda, beta, c, offsetc, ldc);
    }

    protected abstract void dsyrkK(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14);

    @Override
    public void ssyrk(String uplo, String trans, int n, int k, float alpha, float[] a, int lda, float beta, float[] c, int ldc) {
        this.ssyrk(uplo, trans, n, k, alpha, a, 0, lda, beta, c, 0, ldc);
    }

    @Override
    public void ssyrk(String uplo, String trans, int n, int k, float alpha, float[] a, int offseta, int lda, float beta, float[] c, int offsetc, int ldc) {
        this.ssyrkK(uplo, trans, n, k, alpha, a, offseta, lda, beta, c, offsetc, ldc);
    }

    protected abstract void ssyrkK(String var1, String var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float var9, float[] var10, int var11, int var12);

    @Override
    public void dtbmv(String uplo, String trans, String diag, int n, int k, double[] a, int lda, double[] x, int incx) {
        this.dtbmv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    @Override
    public void dtbmv(String uplo, String trans, String diag, int n, int k, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.dtbmvK(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void dtbmvK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    @Override
    public void stbmv(String uplo, String trans, String diag, int n, int k, float[] a, int lda, float[] x, int incx) {
        this.stbmv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    @Override
    public void stbmv(String uplo, String trans, String diag, int n, int k, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.stbmvK(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void stbmvK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    @Override
    public void dtbsv(String uplo, String trans, String diag, int n, int k, double[] a, int lda, double[] x, int incx) {
        this.dtbsv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    @Override
    public void dtbsv(String uplo, String trans, String diag, int n, int k, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.dtbsvK(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void dtbsvK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    @Override
    public void stbsv(String uplo, String trans, String diag, int n, int k, float[] a, int lda, float[] x, int incx) {
        this.stbsv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    @Override
    public void stbsv(String uplo, String trans, String diag, int n, int k, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.stbsvK(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void stbsvK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    @Override
    public void dtpmv(String uplo, String trans, String diag, int n, double[] a, double[] x, int incx) {
        this.dtpmv(uplo, trans, diag, n, a, 0, x, 0, incx);
    }

    @Override
    public void dtpmv(String uplo, String trans, String diag, int n, double[] a, int offseta, double[] x, int offsetx, int incx) {
        this.dtpmvK(uplo, trans, diag, n, a, offseta, x, offsetx, incx);
    }

    protected abstract void dtpmvK(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    @Override
    public void stpmv(String uplo, String trans, String diag, int n, float[] a, float[] x, int incx) {
        this.stpmv(uplo, trans, diag, n, a, 0, x, 0, incx);
    }

    @Override
    public void stpmv(String uplo, String trans, String diag, int n, float[] a, int offseta, float[] x, int offsetx, int incx) {
        this.stpmvK(uplo, trans, diag, n, a, offseta, x, offsetx, incx);
    }

    protected abstract void stpmvK(String var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9);

    @Override
    public void dtpsv(String uplo, String trans, String diag, int n, double[] a, double[] x, int incx) {
        this.dtpsv(uplo, trans, diag, n, a, 0, x, 0, incx);
    }

    @Override
    public void dtpsv(String uplo, String trans, String diag, int n, double[] a, int offseta, double[] x, int offsetx, int incx) {
        this.dtpsvK(uplo, trans, diag, n, a, offseta, x, offsetx, incx);
    }

    protected abstract void dtpsvK(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    @Override
    public void stpsv(String uplo, String trans, String diag, int n, float[] a, float[] x, int incx) {
        this.stpsv(uplo, trans, diag, n, a, 0, x, 0, incx);
    }

    @Override
    public void stpsv(String uplo, String trans, String diag, int n, float[] a, int offseta, float[] x, int offsetx, int incx) {
        this.stpsvK(uplo, trans, diag, n, a, offseta, x, offsetx, incx);
    }

    protected abstract void stpsvK(String var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9);

    @Override
    public void dtrmm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb) {
        this.dtrmm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    @Override
    public void dtrmm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb) {
        this.dtrmmK(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    protected abstract void dtrmmK(String var1, String var2, String var3, String var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    @Override
    public void strmm(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb) {
        this.strmm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    @Override
    public void strmm(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb) {
        this.strmmK(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    protected abstract void strmmK(String var1, String var2, String var3, String var4, int var5, int var6, float var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13);

    @Override
    public void dtrmv(String uplo, String trans, String diag, int n, double[] a, int lda, double[] x, int incx) {
        this.dtrmv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    @Override
    public void dtrmv(String uplo, String trans, String diag, int n, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.dtrmvK(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void dtrmvK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    public void strmv(String uplo, String trans, String diag, int n, float[] a, int lda, float[] x, int incx) {
        this.strmv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    @Override
    public void strmv(String uplo, String trans, String diag, int n, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.strmvK(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void strmvK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10);

    @Override
    public void dtrsm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb) {
        this.dtrsm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    @Override
    public void dtrsm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb) {
        this.dtrsmK(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    protected abstract void dtrsmK(String var1, String var2, String var3, String var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    @Override
    public void strsm(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int lda, float[] b, int ldb) {
        this.strsm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    @Override
    public void strsm(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb) {
        this.strsmK(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    protected abstract void strsmK(String var1, String var2, String var3, String var4, int var5, int var6, float var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13);

    @Override
    public void dtrsv(String uplo, String trans, String diag, int n, double[] a, int lda, double[] x, int incx) {
        this.dtrsv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    @Override
    public void dtrsv(String uplo, String trans, String diag, int n, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.dtrsvK(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void dtrsvK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    public void strsv(String uplo, String trans, String diag, int n, float[] a, int lda, float[] x, int incx) {
        this.strsv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    @Override
    public void strsv(String uplo, String trans, String diag, int n, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.strsvK(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    protected abstract void strsvK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10);

    @Override
    public int idamax(int n, double[] x, int incx) {
        return this.idamax(n, x, 0, incx);
    }

    @Override
    public int idamax(int n, double[] x, int offsetx, int incx) {
        if (n <= 0) {
            return -1;
        }
        if (incx <= 0) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        return this.idamaxK(n, x, offsetx, incx);
    }

    protected abstract int idamaxK(int var1, double[] var2, int var3, int var4);

    @Override
    public int isamax(int n, float[] x, int incx) {
        return this.isamax(n, x, 0, incx);
    }

    @Override
    public int isamax(int n, float[] x, int offsetx, int incx) {
        if (n <= 0) {
            return -1;
        }
        if (incx <= 0) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        return this.isamaxK(n, x, offsetx, incx);
    }

    protected abstract int isamaxK(int var1, float[] var2, int var3, int var4);

    @Override
    public boolean lsame(String ca, String cb) {
        return ca != null && ca.length() == 1 && ca.equalsIgnoreCase(cb);
    }
}

