/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.profiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.TextResult;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.Utils;

public final class VTuneProfiler
implements ExternalProfiler {
    protected final String collect;
    protected final Path perfBinData;

    public VTuneProfiler() {
        this.collect = null;
        this.perfBinData = null;
    }

    public VTuneProfiler(String initParams) throws ProfilerException {
        try {
            this.collect = initParams.isEmpty() ? "uarch-exploration" : initParams;
            this.perfBinData = Files.createTempDirectory("jmh-vtune-bin-", new FileAttribute[0]).toAbsolutePath();
        }
        catch (IOException e) {
            throw new ProfilerException((Exception)e);
        }
    }

    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = TimeUnit.NANOSECONDS.toSeconds((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS)) + TimeUnit.SECONDS.toSeconds(1L);
        return Arrays.asList("vtune", "-collect", this.collect, "-no-summary", "-loop-mode=loop-and-function", "-inline-mode=on", "-resume-after", String.valueOf(delay), "-result-dir", this.perfBinData.toString());
    }

    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    public void beforeTrial(BenchmarkParams params) {
    }

    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        try {
            Process process = new ProcessBuilder("vtune", "-report", "summary", "-r", this.perfBinData.toString()).start();
            Collection lines = FileUtils.readAllLines((InputStream)process.getInputStream());
            String out = Utils.join((Collection)lines, (String)System.lineSeparator());
            return Collections.singleton(new TextResult(out, "vtune"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean allowPrintOut() {
        return false;
    }

    public boolean allowPrintErr() {
        return false;
    }

    public String getDescription() {
        return "Intel VTune profiler";
    }
}

