/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.lapack;

import dev.ludovic.netlib.lapack.JavaLAPACK;
import dev.ludovic.netlib.lapack.LAPACK;
import dev.ludovic.netlib.lapack.NativeLAPACK;
import java.util.Random;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public abstract class LAPACKBenchmark {
    public LAPACK lapack;
    @Param(value={"java", "native"})
    public String implementation;
    private final Random rand = new Random(0L);

    @Setup
    public void setupImplementation() {
        switch (this.implementation) {
            case "java": {
                this.lapack = JavaLAPACK.getInstance();
                break;
            }
            case "native": {
                this.lapack = NativeLAPACK.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown implementation = " + this.implementation);
            }
        }
    }

    protected double randomDouble() {
        return this.rand.nextDouble();
    }

    protected double[] randomDoubleArray(int n) {
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextDouble();
        }
        return res;
    }

    protected float randomFloat() {
        return this.rand.nextFloat();
    }

    protected float[] randomFloatArray(int n) {
        float[] res = new float[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextFloat();
        }
        return res;
    }
}

