/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l2;

import dev.ludovic.netlib.benchmarks.blas.BLASBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class SgemvBenchmark
extends BLASBenchmark {
    @Param(value={"N", "T"})
    public String trans;
    @Param(value={"10", "1000"})
    public int m;
    @Param(value={"10", "1000"})
    public int n;
    public float alpha;
    public float[] a;
    public float[] x;
    public float beta;
    public float[] y;
    public float[] yclone;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomFloat();
        this.a = this.randomFloatArray(this.m * this.n);
        this.x = this.randomFloatArray(this.trans.equals("T") ? this.m : this.n);
        this.beta = this.randomFloat();
        this.y = this.randomFloatArray(this.trans.equals("T") ? this.n : this.m);
    }

    @Setup(value=Level.Invocation)
    public void setupIteration() {
        this.yclone = (float[])this.y.clone();
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.blas.sgemv(this.trans, this.m, this.n, this.alpha, this.a, this.m, this.x, 1, this.beta, this.yclone, 1);
        bh.consume((Object)this.yclone);
    }
}

