/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l2;

import dev.ludovic.netlib.benchmarks.blas.BLASBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class DsprBenchmark
extends BLASBenchmark {
    @Param(value={"U", "L"})
    public String uplo;
    @Param(value={"10", "1000"})
    public int n;
    public double alpha;
    public double[] a;
    public double[] aclone;
    public double[] x;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomDouble();
        this.a = this.randomDoubleArray(this.n * (this.n + 1) / 2);
        this.x = this.randomDoubleArray(this.n);
    }

    @Setup(value=Level.Invocation)
    public void setupIteration() {
        this.aclone = (double[])this.a.clone();
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.blas.dspr(this.uplo, this.n, this.alpha, this.x, 1, this.aclone);
        bh.consume((Object)this.aclone);
    }
}

