/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l2;

import dev.ludovic.netlib.benchmarks.blas.BLASBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class SgerBenchmark
extends BLASBenchmark {
    @Param(value={"10", "1000"})
    public int m;
    @Param(value={"10", "1000"})
    public int n;
    public float alpha;
    public float[] a;
    public float[] aclone;
    public float[] x;
    public float[] y;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomFloat();
        this.a = this.randomFloatArray(this.m * this.n);
        this.x = this.randomFloatArray(this.m);
        this.y = this.randomFloatArray(this.n);
    }

    @Setup(value=Level.Invocation)
    public void setupIteration() {
        this.aclone = (float[])this.a.clone();
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.blas.sger(this.m, this.n, this.alpha, this.x, 1, this.y, 1, this.aclone, this.n);
        bh.consume((Object)this.aclone);
    }
}

