/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l2;

import dev.ludovic.netlib.benchmarks.blas.BLASBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class DsymvBenchmark
extends BLASBenchmark {
    @Param(value={"U", "L"})
    public String uplo;
    @Param(value={"10", "1000"})
    public int n;
    public double alpha;
    public double[] a;
    public double[] x;
    public double beta;
    public double[] y;
    public double[] yclone;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomDouble();
        this.a = this.randomDoubleArray(this.n * this.n);
        this.x = this.randomDoubleArray(this.n);
        this.beta = this.randomDouble();
        this.y = this.randomDoubleArray(this.n);
    }

    @Setup(value=Level.Invocation)
    public void setupIteration() {
        this.yclone = (double[])this.y.clone();
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.blas.dsymv(this.uplo, this.n, this.alpha, this.a, this.n, this.x, 1, this.beta, this.yclone, 1);
        bh.consume((Object)this.yclone);
    }
}

