/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas;

import dev.ludovic.netlib.BLAS;
import dev.ludovic.netlib.blas.CudaBLAS;
import dev.ludovic.netlib.blas.JavaBLAS;
import dev.ludovic.netlib.blas.NativeBLAS;
import dev.ludovic.netlib.blas.NetlibF2jBLAS;
import dev.ludovic.netlib.blas.VectorizedBLAS;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Fork(value=1, jvmArgsPrepend={"--add-modules=jdk.incubator.foreign,jdk.incubator.vector", "-Dforeign.restricted=permit"})
public abstract class BLASBenchmark {
    public BLAS blas;
    @Param(value={"f2j", "native", "java", "vector"})
    public String implementation;
    private final Random rand = new Random(0L);

    @Setup
    public void setupImplementation() {
        switch (this.implementation) {
            case "f2j": {
                this.blas = NetlibF2jBLAS.getInstance();
                break;
            }
            case "java": {
                this.blas = JavaBLAS.getInstance();
                break;
            }
            case "vector": {
                this.blas = VectorizedBLAS.getInstance();
                break;
            }
            case "native": {
                this.blas = NativeBLAS.getInstance();
                break;
            }
            case "cuda": {
                this.blas = CudaBLAS.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown implementation = " + this.implementation);
            }
        }
    }

    protected double randomDouble() {
        return this.rand.nextDouble();
    }

    protected double[] randomDoubleArray(int n) {
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextDouble();
        }
        return res;
    }

    protected float randomFloat() {
        return this.rand.nextFloat();
    }

    protected float[] randomFloatArray(int n) {
        float[] res = new float[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextFloat();
        }
        return res;
    }
}

