/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.searchapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.web.search.searchapi.SearchApi;
import dev.langchain4j.web.search.searchapi.SearchApiWebSearchRequest;
import dev.langchain4j.web.search.searchapi.SearchApiWebSearchResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class SearchApiClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final SearchApi api;

    SearchApiClient(Duration timeout, String baseUrl) {
        ValidationUtils.ensureNotNull((Object)timeout, (String)"timeout");
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(ValidationUtils.ensureNotBlank((String)baseUrl, (String)"baseUrl")).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.api = (SearchApi)retrofit.create(SearchApi.class);
    }

    SearchApiWebSearchResponse search(SearchApiWebSearchRequest request) {
        HashMap<String, Object> finalParameters = new HashMap<String, Object>(request.getFinalOptionalParameters());
        finalParameters.put("engine", request.getEngine());
        finalParameters.put("q", request.getQuery());
        String bearerToken = "Bearer " + request.getApiKey();
        try {
            Response response = this.api.search(finalParameters, bearerToken).execute();
            return this.getBody((Response<SearchApiWebSearchResponse>)response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SearchApiWebSearchResponse getBody(Response<SearchApiWebSearchResponse> response) throws IOException {
        if (response.isSuccessful()) {
            return (SearchApiWebSearchResponse)response.body();
        }
        throw SearchApiClient.toException(response);
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        try (ResponseBody responseBody = response.errorBody();){
            int code = response.code();
            if (responseBody != null) {
                String body = responseBody.string();
                String errorMessage = String.format("status code: %s; body: %s", code, body);
                RuntimeException runtimeException = new RuntimeException(errorMessage);
                return runtimeException;
            }
            RuntimeException runtimeException = new RuntimeException(String.format("status code: %s;", code));
            return runtimeException;
        }
    }

    public static SearchApiClientBuilder builder() {
        return new SearchApiClientBuilder();
    }

    public static class SearchApiClientBuilder {
        private Duration timeout;
        private String baseUrl;

        SearchApiClientBuilder() {
        }

        public SearchApiClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public SearchApiClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public SearchApiClient build() {
            return new SearchApiClient(this.timeout, this.baseUrl);
        }

        public String toString() {
            return "SearchApiClient.SearchApiClientBuilder(timeout=" + this.timeout + ", baseUrl=" + this.baseUrl + ")";
        }
    }
}

