/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.spring;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.FactoryBean;

class AiServiceFactory
implements FactoryBean<Object> {
    private final Class<Object> aiServiceClass;
    private ChatModel chatModel;
    private StreamingChatModel streamingChatModel;
    private ChatMemory chatMemory;
    private ChatMemoryProvider chatMemoryProvider;
    private ContentRetriever contentRetriever;
    private RetrievalAugmentor retrievalAugmentor;
    private ModerationModel moderationModel;
    private ToolProvider toolProvider;
    private List<Object> tools;

    public AiServiceFactory(Class<Object> aiServiceClass) {
        this.aiServiceClass = aiServiceClass;
    }

    public void setChatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
    }

    public void setStreamingChatModel(StreamingChatModel streamingChatModel) {
        this.streamingChatModel = streamingChatModel;
    }

    public void setChatMemory(ChatMemory chatMemory) {
        this.chatMemory = chatMemory;
    }

    public void setChatMemoryProvider(ChatMemoryProvider chatMemoryProvider) {
        this.chatMemoryProvider = chatMemoryProvider;
    }

    public void setContentRetriever(ContentRetriever contentRetriever) {
        this.contentRetriever = contentRetriever;
    }

    public void setRetrievalAugmentor(RetrievalAugmentor retrievalAugmentor) {
        this.retrievalAugmentor = retrievalAugmentor;
    }

    public void setModerationModel(ModerationModel moderationModel) {
        this.moderationModel = moderationModel;
    }

    public void setToolProvider(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    public void setTools(List<Object> tools) {
        this.tools = tools;
    }

    public Object getObject() {
        AiServices builder = AiServices.builder(this.aiServiceClass);
        if (this.chatModel != null) {
            builder = builder.chatModel(this.chatModel);
        }
        if (this.streamingChatModel != null) {
            builder = builder.streamingChatModel(this.streamingChatModel);
        }
        if (this.chatMemory != null) {
            builder.chatMemory(this.chatMemory);
        }
        if (this.chatMemoryProvider != null) {
            builder.chatMemoryProvider(this.chatMemoryProvider);
        }
        if (this.retrievalAugmentor != null) {
            builder = builder.retrievalAugmentor(this.retrievalAugmentor);
        } else if (this.contentRetriever != null) {
            builder = builder.contentRetriever(this.contentRetriever);
        }
        if (this.moderationModel != null) {
            builder = builder.moderationModel(this.moderationModel);
        }
        if (this.toolProvider != null) {
            builder = builder.toolProvider(this.toolProvider);
        }
        if (!Utils.isNullOrEmpty(this.tools)) {
            for (Object tool : this.tools) {
                if (AopUtils.isAopProxy((Object)tool)) {
                    builder = builder.tools(this.aopEnhancedTools(tool));
                    continue;
                }
                builder = builder.tools(new Object[]{tool});
            }
        }
        return builder.build();
    }

    public Class<?> getObjectType() {
        return this.aiServiceClass;
    }

    public boolean isSingleton() {
        return true;
    }

    private Map<ToolSpecification, ToolExecutor> aopEnhancedTools(Object enhancedTool) {
        HashMap<ToolSpecification, ToolExecutor> toolExecutors = new HashMap<ToolSpecification, ToolExecutor>();
        Class originalToolClass = AopProxyUtils.ultimateTargetClass((Object)enhancedTool);
        for (Method originalToolMethod : originalToolClass.getDeclaredMethods()) {
            if (!originalToolMethod.isAnnotationPresent(Tool.class)) continue;
            Arrays.stream(enhancedTool.getClass().getDeclaredMethods()).filter(m -> m.getName().equals(originalToolMethod.getName())).findFirst().ifPresent(enhancedToolMethod -> {
                ToolSpecification toolSpecification = ToolSpecifications.toolSpecificationFrom((Method)originalToolMethod);
                DefaultToolExecutor executor = new DefaultToolExecutor(enhancedTool, originalToolMethod, enhancedToolMethod);
                toolExecutors.put(toolSpecification, (ToolExecutor)executor);
            });
        }
        return toolExecutors;
    }
}

