/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.qdrant;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import io.qdrant.client.ConditionFactory;
import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.UUID;

class QdrantFilterConverter {
    QdrantFilterConverter() {
    }

    public static Points.Filter convertExpression(Filter expression) {
        return QdrantFilterConverter.convertOperand(expression);
    }

    private static Points.Filter convertOperand(Filter operand) {
        Points.Filter.Builder context = Points.Filter.newBuilder();
        ArrayList<Points.Condition> mustClauses = new ArrayList<Points.Condition>();
        ArrayList<Points.Condition> shouldClauses = new ArrayList<Points.Condition>();
        ArrayList<Points.Condition> mustNotClauses = new ArrayList<Points.Condition>();
        if (operand instanceof Not) {
            Not not = (Not)operand;
            mustNotClauses.add(ConditionFactory.filter((Points.Filter)QdrantFilterConverter.convertOperand(not.expression())));
        } else if (operand instanceof And) {
            And and = (And)operand;
            mustClauses.add(ConditionFactory.filter((Points.Filter)QdrantFilterConverter.convertOperand(and.left())));
            mustClauses.add(ConditionFactory.filter((Points.Filter)QdrantFilterConverter.convertOperand(and.right())));
        } else if (operand instanceof Or) {
            Or or = (Or)operand;
            shouldClauses.add(ConditionFactory.filter((Points.Filter)QdrantFilterConverter.convertOperand(or.left())));
            shouldClauses.add(ConditionFactory.filter((Points.Filter)QdrantFilterConverter.convertOperand(or.right())));
        } else {
            mustClauses.add(QdrantFilterConverter.parseComparison(operand));
        }
        return context.addAllMust(mustClauses).addAllShould(shouldClauses).addAllMustNot(mustNotClauses).build();
    }

    private static Points.Condition parseComparison(Filter comparision) {
        if (comparision instanceof IsEqualTo) {
            return QdrantFilterConverter.buildEqCondition((IsEqualTo)comparision);
        }
        if (comparision instanceof IsNotEqualTo) {
            return QdrantFilterConverter.buildNeCondition((IsNotEqualTo)comparision);
        }
        if (comparision instanceof IsGreaterThan) {
            return QdrantFilterConverter.buildGtCondition((IsGreaterThan)comparision);
        }
        if (comparision instanceof IsGreaterThanOrEqualTo) {
            return QdrantFilterConverter.buildGteCondition((IsGreaterThanOrEqualTo)comparision);
        }
        if (comparision instanceof IsLessThan) {
            return QdrantFilterConverter.buildLtCondition((IsLessThan)comparision);
        }
        if (comparision instanceof IsLessThanOrEqualTo) {
            return QdrantFilterConverter.buildLteCondition((IsLessThanOrEqualTo)comparision);
        }
        if (comparision instanceof IsIn) {
            return QdrantFilterConverter.buildInCondition((IsIn)comparision);
        }
        if (comparision instanceof IsNotIn) {
            return QdrantFilterConverter.buildNInCondition((IsNotIn)comparision);
        }
        throw new UnsupportedOperationException("Unsupported comparision type: " + String.valueOf(comparision));
    }

    private static Points.Condition buildEqCondition(IsEqualTo equalTo) {
        String key = equalTo.key();
        Object value = equalTo.comparisonValue();
        if (value instanceof String || value instanceof UUID) {
            return ConditionFactory.matchKeyword((String)key, (String)value.toString());
        }
        if (value instanceof Boolean) {
            return ConditionFactory.match((String)key, (boolean)((Boolean)value));
        }
        if (value instanceof Integer || value instanceof Long) {
            long lValue = Long.parseLong(value.toString());
            return ConditionFactory.match((String)key, (long)lValue);
        }
        throw new IllegalArgumentException("Invalid value type for IsEqualTo. Can either be a String or Boolean or Integer or Long");
    }

    private static Points.Condition buildNeCondition(IsNotEqualTo notEqual) {
        String key = notEqual.key();
        Object value = notEqual.comparisonValue();
        if (value instanceof String || value instanceof UUID) {
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(ConditionFactory.matchKeyword((String)key, (String)value.toString())).build());
        }
        if (value instanceof Boolean) {
            Points.Condition condition = ConditionFactory.match((String)key, (boolean)((Boolean)value));
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(condition).build());
        }
        if (value instanceof Integer || value instanceof Long) {
            long lValue = Long.parseLong(value.toString());
            Points.Condition condition = ConditionFactory.match((String)key, (long)lValue);
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(condition).build());
        }
        throw new IllegalArgumentException("Invalid value type for IsNotEqualto. Can either be a String or Boolean or Integer or Long");
    }

    private static Points.Condition buildGtCondition(IsGreaterThan greaterThan) {
        String key = greaterThan.key();
        Comparable value = greaterThan.comparisonValue();
        if (value instanceof Number) {
            Double dvalue = Double.parseDouble(value.toString());
            return ConditionFactory.range((String)key, (Points.Range)Points.Range.newBuilder().setGt(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for IsGreaterThan condition. Only supports Number");
    }

    private static Points.Condition buildLtCondition(IsLessThan lessThan) {
        String key = lessThan.key();
        Comparable value = lessThan.comparisonValue();
        if (value instanceof Number) {
            Double dvalue = Double.parseDouble(value.toString());
            return ConditionFactory.range((String)key, (Points.Range)Points.Range.newBuilder().setLt(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for IsLessThan condition. Only supports Number");
    }

    private static Points.Condition buildGteCondition(IsGreaterThanOrEqualTo greaterThanOrEqualTo) {
        String key = greaterThanOrEqualTo.key();
        Comparable value = greaterThanOrEqualTo.comparisonValue();
        if (value instanceof Number) {
            Double dvalue = Double.parseDouble(value.toString());
            return ConditionFactory.range((String)key, (Points.Range)Points.Range.newBuilder().setGte(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for IsGreaterThanOrEqualTo condition. Only supports Number");
    }

    private static Points.Condition buildLteCondition(IsLessThanOrEqualTo lessThanOrEqualTo) {
        String key = lessThanOrEqualTo.key();
        Comparable value = lessThanOrEqualTo.comparisonValue();
        if (value instanceof Number) {
            Double dvalue = Double.parseDouble(value.toString());
            return ConditionFactory.range((String)key, (Points.Range)Points.Range.newBuilder().setLte(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for IsLessThanOrEqualTo condition. Only supports Number");
    }

    private static Points.Condition buildInCondition(IsIn in) {
        String key = in.key();
        ArrayList valueList = new ArrayList(in.comparisonValues());
        Object firstValue = valueList.get(0);
        if (firstValue instanceof String || firstValue instanceof UUID) {
            ArrayList<String> stringValues = new ArrayList<String>();
            for (Object valueObj : valueList) {
                stringValues.add(valueObj.toString());
            }
            return ConditionFactory.matchKeywords((String)key, stringValues);
        }
        if (firstValue instanceof Integer || firstValue instanceof Long) {
            ArrayList<Long> longValues = new ArrayList<Long>();
            for (Object valueObj : valueList) {
                Long longValue = Long.parseLong(valueObj.toString());
                longValues.add(longValue);
            }
            return ConditionFactory.matchValues((String)key, longValues);
        }
        throw new RuntimeException("Unsupported value in IsIn value list. Only supports String or Integer or Long");
    }

    private static Points.Condition buildNInCondition(IsNotIn notIn) {
        String key = notIn.key();
        ArrayList valueList = new ArrayList(notIn.comparisonValues());
        Object firstValue = valueList.get(0);
        if (firstValue instanceof String || firstValue instanceof UUID) {
            ArrayList<String> stringValues = new ArrayList<String>();
            for (Object valueObj : valueList) {
                stringValues.add(valueObj.toString());
            }
            return ConditionFactory.matchExceptKeywords((String)key, stringValues);
        }
        if (firstValue instanceof Integer || firstValue instanceof Long) {
            ArrayList<Long> longValues = new ArrayList<Long>();
            for (Object valueObj : valueList) {
                Long longValue = Long.parseLong(valueObj.toString());
                longValues.add(longValue);
            }
            return ConditionFactory.matchExceptValues((String)key, longValues);
        }
        throw new RuntimeException("Unsupported value in IsNotIn value list. Only supports String or Integer or Long");
    }
}

