/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.pinecone;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.pinecone.PineconeIndexConfig;
import io.pinecone.clients.Pinecone;

public class PineconeServerlessIndexConfig
implements PineconeIndexConfig {
    private final Integer dimension;
    private final String cloud;
    private final String region;

    PineconeServerlessIndexConfig(Integer dimension, String cloud, String region) {
        cloud = (String)ValidationUtils.ensureNotNull((Object)cloud, (String)"cloud");
        region = (String)ValidationUtils.ensureNotNull((Object)region, (String)"region");
        ValidationUtils.ensureNotNull((Object)dimension, (String)"dimension");
        this.dimension = dimension;
        this.cloud = cloud;
        this.region = region;
    }

    @Override
    public void createIndex(Pinecone pinecone, String index) {
        ValidationUtils.ensureNotNull((Object)pinecone, (String)"pinecone");
        ValidationUtils.ensureNotNull((Object)index, (String)"index");
        pinecone.createServerlessIndex(index, "cosine", this.dimension.intValue(), this.cloud, this.region);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer dimension;
        private String cloud;
        private String region;

        public Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder cloud(String cloud) {
            this.cloud = cloud;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public PineconeServerlessIndexConfig build() {
            return new PineconeServerlessIndexConfig(this.dimension, this.cloud, this.region);
        }
    }
}

