/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.langchain4j.data.document.DocumentSegment;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.pinecone.PineconeClient;
import io.pinecone.PineconeClientConfig;
import io.pinecone.PineconeConnection;
import io.pinecone.PineconeConnectionConfig;
import io.pinecone.proto.FetchRequest;
import io.pinecone.proto.QueryRequest;
import io.pinecone.proto.QueryVector;
import io.pinecone.proto.ScoredVector;
import io.pinecone.proto.SingleQueryResults;
import io.pinecone.proto.UpsertRequest;
import io.pinecone.proto.Vector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class PineconeEmbeddingStoreImpl
implements EmbeddingStore<DocumentSegment> {
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String METADATA_DOCUMENT_SEGMENT_TEXT = "document_segment_text";
    private final PineconeConnection connection;
    private final String nameSpace;

    public PineconeEmbeddingStoreImpl(String apiKey, String environment, String projectName, String index, String nameSpace) {
        PineconeClientConfig configuration = new PineconeClientConfig().withApiKey(apiKey).withEnvironment(environment).withProjectName(projectName);
        PineconeClient pineconeClient = new PineconeClient(configuration);
        PineconeConnectionConfig connectionConfig = new PineconeConnectionConfig().withIndexName(index);
        this.connection = pineconeClient.connect(connectionConfig);
        this.nameSpace = nameSpace == null ? DEFAULT_NAMESPACE : nameSpace;
    }

    public String add(Embedding embedding) {
        String id = PineconeEmbeddingStoreImpl.generateRandomId(embedding);
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, DocumentSegment documentSegment) {
        String id = PineconeEmbeddingStoreImpl.generateRandomId(embedding);
        this.addInternal(id, embedding, documentSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(PineconeEmbeddingStoreImpl::generateRandomId).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<DocumentSegment> documentSegments) {
        List<String> ids = embeddings.stream().map(PineconeEmbeddingStoreImpl::generateRandomId).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, documentSegments);
        return ids;
    }

    private void addInternal(String id, Embedding embedding, DocumentSegment documentSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), documentSegment == null ? null : Collections.singletonList(documentSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<DocumentSegment> documentSegments) {
        UpsertRequest.Builder upsertRequestBuilder = UpsertRequest.newBuilder().setNamespace(this.nameSpace);
        for (int i = 0; i < embeddings.size(); ++i) {
            String id = ids.get(i);
            Embedding embedding = embeddings.get(i);
            DocumentSegment documentSegment = documentSegments.get(i);
            Struct vectorMetadata = Struct.newBuilder().putFields(METADATA_DOCUMENT_SEGMENT_TEXT, Value.newBuilder().setStringValue(documentSegment.text()).build()).build();
            Vector vector = Vector.newBuilder().setId(id).addAllValues((Iterable)embedding.vectorAsList()).setMetadata(vectorMetadata).build();
            upsertRequestBuilder.addVectors(vector);
        }
        this.connection.getBlockingStub().upsert(upsertRequestBuilder.build());
    }

    public List<EmbeddingMatch<DocumentSegment>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.findRelevant(referenceEmbedding, maxResults, -1.0);
    }

    public List<EmbeddingMatch<DocumentSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minSimilarity) {
        QueryVector queryVector = QueryVector.newBuilder().addAllValues((Iterable)referenceEmbedding.vectorAsList()).setTopK(maxResults).setNamespace(this.nameSpace).build();
        QueryRequest queryRequest = QueryRequest.newBuilder().addQueries(queryVector).setTopK(maxResults).build();
        List matchedVectorIds = ((SingleQueryResults)this.connection.getBlockingStub().query(queryRequest).getResultsList().get(0)).getMatchesList().stream().map(ScoredVector::getId).collect(Collectors.toList());
        if (matchedVectorIds.isEmpty()) {
            return Collections.emptyList();
        }
        Collection matchedVectors = this.connection.getBlockingStub().fetch(FetchRequest.newBuilder().addAllIds(matchedVectorIds).setNamespace(this.nameSpace).build()).getVectorsMap().values();
        return matchedVectors.stream().map(PineconeEmbeddingStoreImpl::toEmbeddingMatch).collect(Collectors.toList());
    }

    private static EmbeddingMatch<DocumentSegment> toEmbeddingMatch(Vector vector) {
        Value documentSegmentTextValue = (Value)vector.getMetadata().getFieldsMap().get(METADATA_DOCUMENT_SEGMENT_TEXT);
        return new EmbeddingMatch(vector.getId(), Embedding.from((List)vector.getValuesList()), (Object)PineconeEmbeddingStoreImpl.createDocumentSegmentIfExists(documentSegmentTextValue), null);
    }

    private static DocumentSegment createDocumentSegmentIfExists(Value documentSegmentTextValue) {
        if (documentSegmentTextValue == null) {
            return null;
        }
        return DocumentSegment.from((String)documentSegmentTextValue.getStringValue());
    }

    private static String generateRandomId(Embedding embedding) {
        return UUID.randomUUID().toString();
    }

    public static PineconeEmbeddingStoreImplBuilder builder() {
        return new PineconeEmbeddingStoreImplBuilder();
    }

    public static class PineconeEmbeddingStoreImplBuilder {
        private String apiKey;
        private String environment;
        private String projectName;
        private String index;
        private String nameSpace;

        PineconeEmbeddingStoreImplBuilder() {
        }

        public PineconeEmbeddingStoreImplBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public PineconeEmbeddingStoreImplBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public PineconeEmbeddingStoreImplBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public PineconeEmbeddingStoreImplBuilder index(String index) {
            this.index = index;
            return this;
        }

        public PineconeEmbeddingStoreImplBuilder nameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
            return this;
        }

        public PineconeEmbeddingStoreImpl build() {
            return new PineconeEmbeddingStoreImpl(this.apiKey, this.environment, this.projectName, this.index, this.nameSpace);
        }

        public String toString() {
            return "PineconeEmbeddingStoreImpl.PineconeEmbeddingStoreImplBuilder(apiKey=" + this.apiKey + ", environment=" + this.environment + ", projectName=" + this.projectName + ", index=" + this.index + ", nameSpace=" + this.nameSpace + ")";
        }
    }
}

