/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.oracle;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import dev.langchain4j.store.embedding.oracle.SQLFilter;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SQLFilters {
    static final SQLFilter EMPTY = new SQLEmptyFilter();
    private static final Map<Class<? extends Filter>, FilterConstructor> CONSTRUCTORS;

    private SQLFilters() {
    }

    static SQLFilter create(Filter filter, BiFunction<String, SQLType, String> keyMapper) {
        if (filter == null) {
            return EMPTY;
        }
        Class filterClass = filter.getClass();
        FilterConstructor constructor = CONSTRUCTORS.get(filterClass);
        if (constructor == null) {
            throw new IllegalArgumentException("Unrecognized Filter class: " + filterClass);
        }
        return constructor.construct(filter, keyMapper);
    }

    static Object toJdbcObject(Object object) {
        if (object instanceof UUID) {
            return object.toString();
        }
        return object;
    }

    static SQLType toSQLType(Collection<?> objects) {
        Set jdbcTypes = objects.stream().map(SQLFilters::toSQLType).collect(Collectors.toSet());
        if (jdbcTypes.size() != 1) {
            throw new IllegalArgumentException("Filters comparing a Collection of non-uniform object classes are not supported. The Collection contains objects of the following classes: " + objects.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        return (SQLType)jdbcTypes.iterator().next();
    }

    static SQLType toSQLType(Object object) {
        if (object instanceof Number) {
            if (object instanceof Float) {
                return JDBCType.REAL;
            }
            if (object instanceof Double) {
                return JDBCType.FLOAT;
            }
            if (object instanceof Integer) {
                return JDBCType.INTEGER;
            }
            if (object instanceof Long) {
                return JDBCType.NUMERIC;
            }
            throw new RuntimeException("Unsupported type: " + object.getClass());
        }
        return JDBCType.VARCHAR;
    }

    static {
        HashMap<Class<Not>, FilterConstructor> map = new HashMap<Class<Not>, FilterConstructor>();
        map.put(IsEqualTo.class, (filter, keyMapper) -> new SQLComparisonFilter((IsEqualTo)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsNotEqualTo.class, (filter, keyMapper) -> new SQLComparisonFilter((IsNotEqualTo)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsGreaterThan.class, (filter, keyMapper) -> new SQLComparisonFilter((IsGreaterThan)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsGreaterThanOrEqualTo.class, (filter, keyMapper) -> new SQLComparisonFilter((IsGreaterThanOrEqualTo)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsLessThan.class, (filter, keyMapper) -> new SQLComparisonFilter((IsLessThan)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsLessThanOrEqualTo.class, (filter, keyMapper) -> new SQLComparisonFilter((IsLessThanOrEqualTo)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsIn.class, (filter, keyMapper) -> new SQLInFilter((IsIn)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(IsNotIn.class, (filter, keyMapper) -> new SQLInFilter((IsNotIn)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(And.class, (filter, keyMapper) -> new SQLLogicalFilter((And)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(Or.class, (filter, keyMapper) -> new SQLLogicalFilter((Or)filter, (BiFunction<String, SQLType, String>)keyMapper));
        map.put(Not.class, (filter, keyMapper) -> new SQLNot((Not)filter, keyMapper));
        CONSTRUCTORS = Collections.unmodifiableMap(map);
    }

    static interface FilterConstructor {
        public SQLFilter construct(Filter var1, BiFunction<String, SQLType, String> var2);
    }

    private static class SQLNot
    implements SQLFilter {
        private final SQLFilter expression;
        private final String sql;

        SQLNot(Not not, BiFunction<String, SQLType, String> keyMapper) {
            this.expression = SQLFilters.create(not.expression(), keyMapper);
            this.sql = "NOT(" + this.expression.toSQL() + ")";
        }

        @Override
        public String toSQL() {
            return this.sql;
        }

        @Override
        public int setParameters(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
            return this.expression.setParameters(preparedStatement, parameterIndex);
        }
    }

    private static class SQLLogicalFilter
    implements SQLFilter {
        private final SQLFilter left;
        private final SQLFilter right;
        private final String sql;

        SQLLogicalFilter(And and, BiFunction<String, SQLType, String> keyMapper) {
            this(and.left(), "AND", and.right(), keyMapper);
        }

        SQLLogicalFilter(Or or, BiFunction<String, SQLType, String> keyMapper) {
            this(or.left(), "OR", or.right(), keyMapper);
        }

        private SQLLogicalFilter(Filter left, String operator, Filter right, BiFunction<String, SQLType, String> keyMapper) {
            this(SQLFilters.create(left, keyMapper), operator, SQLFilters.create(right, keyMapper));
        }

        private SQLLogicalFilter(SQLFilter left, String operator, SQLFilter right) {
            this.left = left;
            this.right = right;
            this.sql = "(" + left.toSQL() + " " + operator + " " + right.toSQL() + ")";
        }

        @Override
        public String toSQL() {
            return this.sql;
        }

        @Override
        public int setParameters(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
            int leftCount = this.left.setParameters(preparedStatement, parameterIndex);
            int rightCount = this.right.setParameters(preparedStatement, parameterIndex + leftCount);
            return leftCount + rightCount;
        }
    }

    private static class SQLInFilter
    implements SQLFilter {
        private final String sql;
        private final SQLType sqlType;
        private final Collection<?> comparisonValues;

        SQLInFilter(IsIn isIn, BiFunction<String, SQLType, String> keyMapper) {
            this(isIn.key(), keyMapper, true, isIn.comparisonValues());
        }

        SQLInFilter(IsNotIn isNotIn, BiFunction<String, SQLType, String> keyMapper) {
            this(isNotIn.key(), keyMapper, false, isNotIn.comparisonValues());
        }

        private SQLInFilter(String key, BiFunction<String, SQLType, String> keyMapper, boolean isIn, Collection<?> comparisonValues) {
            this.sqlType = SQLFilters.toSQLType(comparisonValues);
            this.sql = "NVL(" + keyMapper.apply(key, this.sqlType) + (isIn ? " IN " : " NOT IN ") + "(" + Stream.generate(() -> "?").limit(comparisonValues.size()).collect(Collectors.joining(", ")) + "), " + !isIn + ")";
            this.comparisonValues = comparisonValues;
        }

        @Override
        public String toSQL() {
            return this.sql;
        }

        @Override
        public int setParameters(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
            for (Object object : this.comparisonValues) {
                preparedStatement.setObject(parameterIndex++, SQLFilters.toJdbcObject(object), this.sqlType);
            }
            return this.comparisonValues.size();
        }
    }

    private static class SQLComparisonFilter
    implements SQLFilter {
        private final String sql;
        private final SQLType sqlType;
        private final Object comparisonValue;

        SQLComparisonFilter(IsEqualTo isEqualTo, BiFunction<String, SQLType, String> keyMapper) {
            this(isEqualTo.key(), keyMapper, "=", isEqualTo.comparisonValue(), false);
        }

        SQLComparisonFilter(IsNotEqualTo isNotEqualTo, BiFunction<String, SQLType, String> keyMapper) {
            this(isNotEqualTo.key(), keyMapper, "<>", isNotEqualTo.comparisonValue(), true);
        }

        SQLComparisonFilter(IsGreaterThan isGreaterThan, BiFunction<String, SQLType, String> keyMapper) {
            this(isGreaterThan.key(), keyMapper, ">", isGreaterThan.comparisonValue(), false);
        }

        SQLComparisonFilter(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo, BiFunction<String, SQLType, String> keyMapper) {
            this(isGreaterThanOrEqualTo.key(), keyMapper, ">=", isGreaterThanOrEqualTo.comparisonValue(), false);
        }

        SQLComparisonFilter(IsLessThan isLessThan, BiFunction<String, SQLType, String> keyMapper) {
            this(isLessThan.key(), keyMapper, "<", isLessThan.comparisonValue(), false);
        }

        SQLComparisonFilter(IsLessThanOrEqualTo isLessThanOrEqualTo, BiFunction<String, SQLType, String> keyMapper) {
            this(isLessThanOrEqualTo.key(), keyMapper, "<=", isLessThanOrEqualTo.comparisonValue(), false);
        }

        private <T> SQLComparisonFilter(String key, BiFunction<String, SQLType, String> keyMapper, String operator, T comparisonValue, boolean isNullTrue) {
            this.sqlType = SQLFilters.toSQLType(comparisonValue);
            this.sql = "NVL(" + keyMapper.apply(key, this.sqlType) + " " + operator + " ?, " + isNullTrue + ")";
            this.comparisonValue = comparisonValue;
        }

        @Override
        public String toSQL() {
            return this.sql;
        }

        @Override
        public int setParameters(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
            preparedStatement.setObject(parameterIndex, SQLFilters.toJdbcObject(this.comparisonValue), this.sqlType);
            return 1;
        }
    }

    private static final class SQLEmptyFilter
    implements SQLFilter {
        private SQLEmptyFilter() {
        }

        @Override
        public String toSQL() {
            return "";
        }

        @Override
        public int setParameters(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
            return 0;
        }

        @Override
        public String asWhereClause() {
            return "";
        }
    }
}

