/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.apache;

import dev.langchain4j.Experimental;
import dev.langchain4j.http.client.FormDataFile;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;

@Experimental
class MultipartBodyPublisher {
    private static final String BOUNDARY = "----LangChain4j";
    private static final String CRLF = "\r\n";
    private final List<byte[]> parts = new ArrayList<byte[]>();

    MultipartBodyPublisher() {
    }

    List<byte[]> parts() {
        return this.parts;
    }

    void addField(String name, String value) {
        String part = "------LangChain4j\r\nContent-Disposition: form-data; name=\"" + name + "\"\r\n\r\n" + value + CRLF;
        this.parts.add(part.getBytes(StandardCharsets.UTF_8));
    }

    void addFile(String name, FormDataFile file) {
        String header = "------LangChain4j\r\nContent-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.fileName() + "\"\r\nContent-Type: " + file.contentType() + "\r\n\r\n";
        this.parts.add(header.getBytes(StandardCharsets.UTF_8));
        this.parts.add(file.content());
        this.parts.add(CRLF.getBytes(StandardCharsets.UTF_8));
    }

    void build() {
        String end = "------LangChain4j--\r\n";
        this.parts.add(end.getBytes(StandardCharsets.UTF_8));
    }

    static HttpEntity buildMultipartEntity(Map<String, String> formDataFields, Map<String, FormDataFile> formDataFiles) {
        MultipartBodyPublisher publisher = new MultipartBodyPublisher();
        for (Map.Entry<String, String> entry : formDataFields.entrySet()) {
            publisher.addField(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : formDataFiles.entrySet()) {
            publisher.addFile(entry.getKey(), (FormDataFile)entry.getValue());
        }
        publisher.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (byte[] part : publisher.parts()) {
            out.write(part, 0, part.length);
        }
        ContentType contentType = ContentType.MULTIPART_FORM_DATA.withParameters(new NameValuePair[]{new BasicNameValuePair("boundary", BOUNDARY)});
        return new ByteArrayEntity(out.toByteArray(), contentType);
    }
}

