/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.gpullama3;

import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.List;
import org.beehive.gpullama3.model.Model;

public class GPULlama3ResponseParser {
    private GPULlama3ResponseParser() {
    }

    public static ParsedResponse parseResponse(String rawResponse) {
        if (rawResponse == null) {
            throw new IllegalArgumentException("Raw response cannot be null");
        }
        String thinking = null;
        String actualResponse = rawResponse;
        int thinkStart = rawResponse.indexOf("<think>");
        int thinkEnd = rawResponse.indexOf("</think>");
        if (thinkStart != -1 && thinkEnd != -1 && thinkEnd > thinkStart) {
            thinking = rawResponse.substring(thinkStart, thinkEnd + 8).trim();
            String beforeThink = rawResponse.substring(0, thinkStart);
            String afterThink = rawResponse.substring(thinkEnd + 8);
            actualResponse = (beforeThink + afterThink).trim();
            actualResponse = actualResponse.replaceAll("\\s+", " ").trim();
        }
        return new ParsedResponse(thinking, actualResponse);
    }

    public static String extractThinking(String rawResponse) {
        return GPULlama3ResponseParser.parseResponse(rawResponse).getThinkingContent();
    }

    public static String extractResponse(String rawResponse) {
        return GPULlama3ResponseParser.parseResponse(rawResponse).getActualResponse();
    }

    public static StreamingParser createStreamingParser(StreamingChatResponseHandler handler, Model model) {
        return new StreamingParser(handler, model);
    }

    public static class ParsedResponse {
        private final String thinkingContent;
        private final String actualResponse;

        public ParsedResponse(String thinkingContent, String actualResponse) {
            this.thinkingContent = thinkingContent;
            this.actualResponse = actualResponse;
        }

        public String getThinkingContent() {
            return this.thinkingContent;
        }

        public String getActualResponse() {
            return this.actualResponse;
        }

        public boolean hasThinking() {
            return this.thinkingContent != null && !this.thinkingContent.trim().isEmpty();
        }
    }

    public static class StreamingParser {
        private final StreamingChatResponseHandler handler;
        private final Model model;
        private final StringBuilder buffer = new StringBuilder();
        private boolean insideThinking = false;
        private int lastProcessedLength = 0;

        public StreamingParser(StreamingChatResponseHandler handler, Model model) {
            this.handler = handler;
            this.model = model;
        }

        public void onToken(int tokenId) {
            if (this.model.chatFormat().getStopTokens().contains(tokenId)) {
                return;
            }
            String tokenStr = this.model.tokenizer().decode(List.of(Integer.valueOf(tokenId)));
            this.buffer.append(tokenStr);
            String currentText = this.buffer.toString();
            this.processNewContent(currentText);
        }

        private void processNewContent(String currentText) {
            if (currentText.length() <= this.lastProcessedLength) {
                return;
            }
            String newContent = currentText.substring(this.lastProcessedLength);
            for (int i = 0; i < newContent.length(); ++i) {
                int currentPosition = this.lastProcessedLength + i;
                if (!this.insideThinking && this.isStartOfThinkTag(currentText, currentPosition)) {
                    this.insideThinking = true;
                    this.handler.onPartialThinking(new PartialThinking("<think>"));
                    i += 6;
                    continue;
                }
                if (this.insideThinking && this.isStartOfEndThinkTag(currentText, currentPosition)) {
                    this.handler.onPartialThinking(new PartialThinking("</think>"));
                    this.insideThinking = false;
                    i += 7;
                    continue;
                }
                char c = newContent.charAt(i);
                if (this.insideThinking) {
                    this.handler.onPartialThinking(new PartialThinking(String.valueOf(c)));
                    continue;
                }
                this.handler.onPartialResponse(String.valueOf(c));
            }
            this.lastProcessedLength = currentText.length();
        }

        private boolean isStartOfThinkTag(String text, int position) {
            return position + 7 <= text.length() && text.regionMatches(position, "<think>", 0, 7);
        }

        private boolean isStartOfEndThinkTag(String text, int position) {
            return position + 8 <= text.length() && text.regionMatches(position, "</think>", 0, 8);
        }
    }
}

