/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding.onnx;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.onnx.AbstractInProcessEmbeddingModel;
import dev.langchain4j.model.embedding.onnx.OnnxBertBiEncoder;
import dev.langchain4j.model.embedding.onnx.PoolingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;

public class OnnxEmbeddingModel
extends AbstractInProcessEmbeddingModel {
    private final OnnxBertBiEncoder onnxBertBiEncoder;

    public OnnxEmbeddingModel(Path pathToModel, Path pathToTokenizer, PoolingMode poolingMode) {
        super(null);
        this.onnxBertBiEncoder = OnnxEmbeddingModel.loadFromFileSystem(pathToModel, pathToTokenizer, poolingMode);
    }

    public OnnxEmbeddingModel(Path pathToModel, Path pathToTokenizer, PoolingMode poolingMode, Executor executor) {
        super((Executor)ValidationUtils.ensureNotNull((Object)executor, (String)"executor"));
        this.onnxBertBiEncoder = OnnxEmbeddingModel.loadFromFileSystem(pathToModel, pathToTokenizer, poolingMode);
    }

    public OnnxEmbeddingModel(String pathToModel, String pathToTokenizer, PoolingMode poolingMode) {
        this(Paths.get(pathToModel, new String[0]), Paths.get(pathToTokenizer, new String[0]), poolingMode);
    }

    public OnnxEmbeddingModel(String pathToModel, String pathToTokenizer, PoolingMode poolingMode, Executor executor) {
        this(Paths.get(pathToModel, new String[0]), Paths.get(pathToTokenizer, new String[0]), poolingMode, executor);
    }

    @Deprecated
    public OnnxEmbeddingModel(Path pathToModel) {
        super(null);
        this.onnxBertBiEncoder = OnnxEmbeddingModel.loadFromFileSystem(pathToModel, OnnxEmbeddingModel.class.getResourceAsStream("/bert-tokenizer.json"), PoolingMode.MEAN);
    }

    @Deprecated
    public OnnxEmbeddingModel(String pathToModel) {
        this(Paths.get(pathToModel, new String[0]));
    }

    @Override
    protected OnnxBertBiEncoder model() {
        return this.onnxBertBiEncoder;
    }
}

