/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import dev.langchain4j.model.embedding.BertTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OnnxBertEmbeddingModel {
    private final OrtEnvironment environment;
    private final OrtSession session;
    private final BertTokenizer tokenizer;

    public OnnxBertEmbeddingModel(InputStream modelInputStream) {
        try {
            this.environment = OrtEnvironment.getEnvironment();
            this.session = this.environment.createSession(this.loadModel(modelInputStream));
            this.tokenizer = new BertTokenizer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public float[] embed(String text) {
        float[] fArray;
        block8: {
            OrtSession.Result result = this.runModel(text);
            try {
                fArray = OnnxBertEmbeddingModel.toEmbedding(result);
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            result.close();
        }
        return fArray;
    }

    /*
     * Exception decompiling
     */
    private OrtSession.Result runModel(String text) throws OrtException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] loadModel(InputStream modelInputStream) {
        try (InputStream inputStream = modelInputStream;){
            byte[] byArray;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[1024];
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static float[] toEmbedding(OrtSession.Result result) throws OrtException {
        float[][] vectors = ((float[][][])result.get(0).getValue())[0];
        return OnnxBertEmbeddingModel.normalize(OnnxBertEmbeddingModel.meanPool(vectors));
    }

    private static float[] meanPool(float[][] vectors) {
        int numVectors = vectors.length;
        int vectorLength = vectors[0].length;
        float[] averagedVector = new float[vectorLength];
        for (int i = 0; i < numVectors; ++i) {
            for (int j = 0; j < vectorLength; ++j) {
                int n = j;
                averagedVector[n] = averagedVector[n] + vectors[i][j];
            }
        }
        int j = 0;
        while (j < vectorLength) {
            int n = j++;
            averagedVector[n] = averagedVector[n] / (float)numVectors;
        }
        return averagedVector;
    }

    private static float[] normalize(float[] vector) {
        float sumSquare = 0.0f;
        for (float v : vector) {
            sumSquare += v * v;
        }
        float norm = (float)Math.sqrt(sumSquare);
        float[] normalizedVector = new float[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            normalizedVector[i] = vector[i] / norm;
        }
        return normalizedVector;
    }

    int countTokens(String text) {
        return this.tokenizer.tokenize(text).size();
    }
}

