/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser.markdown;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.text.TextContentRenderer;

public class MarkdownDocumentParser
implements DocumentParser {
    public Document parse(InputStream inputStream) {
        try {
            Parser parser = Parser.builder().build();
            Node node = parser.parseReader((Reader)new InputStreamReader(inputStream));
            TextContentRenderer renderer = TextContentRenderer.builder().build();
            String text = renderer.render(node);
            if (Utils.isNullOrBlank((String)text)) {
                throw new BlankDocumentException();
            }
            return Document.from((String)text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

