/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.tencent.cos;

import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import dev.langchain4j.internal.ValidationUtils;

public class TencentCredentials {
    private final String secretId;
    private final String secretKey;
    private final String sessionToken;

    public TencentCredentials(String secretId, String secretKey) {
        this(secretId, secretKey, null);
    }

    public TencentCredentials(String secretId, String secretKey, String sessionToken) {
        this.secretId = ValidationUtils.ensureNotBlank((String)secretId, (String)"accessKeyId");
        this.secretKey = ValidationUtils.ensureNotBlank((String)secretKey, (String)"secretAccessKey");
        this.sessionToken = sessionToken;
    }

    public COSCredentialsProvider toCredentialsProvider() {
        return new COSStaticCredentialsProvider(this.toCredentials());
    }

    public COSCredentials toCredentials() {
        if (this.sessionToken == null) {
            return new BasicCOSCredentials(this.secretId, this.secretKey);
        }
        return new BasicSessionCredentials(this.secretId, this.secretKey, this.sessionToken);
    }
}

