/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.tencent.cos;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.region.Region;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.loader.tencent.cos.TencentCredentials;
import dev.langchain4j.data.document.source.tencent.cos.TencentCosSource;
import dev.langchain4j.internal.ValidationUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentCosDocumentLoader {
    private static final Logger log = LoggerFactory.getLogger(TencentCosDocumentLoader.class);
    private final COSClient cosClient;

    public TencentCosDocumentLoader(COSClient s3Client) {
        this.cosClient = (COSClient)ValidationUtils.ensureNotNull((Object)s3Client, (String)"cosClient");
    }

    public Document loadDocument(String bucket, String key, DocumentParser parser) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucket, key);
        COSObject cosObject = this.cosClient.getObject(getObjectRequest);
        TencentCosSource source = new TencentCosSource((InputStream)cosObject.getObjectContent(), bucket, key);
        return DocumentLoader.load((DocumentSource)source, (DocumentParser)parser);
    }

    public List<Document> loadDocuments(String bucket, DocumentParser parser) {
        return this.loadDocuments(bucket, null, parser);
    }

    public List<Document> loadDocuments(String bucket, String prefix, DocumentParser parser) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(ValidationUtils.ensureNotBlank((String)bucket, (String)"bucket")).withPrefix(prefix);
        ObjectListing objectListing = this.cosClient.listObjects(listObjectsRequest);
        List filteredObjects = objectListing.getObjectSummaries().stream().filter(object -> !object.getKey().endsWith("/") && object.getSize() > 0L).collect(Collectors.toList());
        for (COSObjectSummary object2 : filteredObjects) {
            String key = object2.getKey();
            try {
                Document document = this.loadDocument(bucket, key, parser);
                documents.add(document);
            }
            catch (Exception e) {
                log.warn("Failed to load an object with key '{}' from bucket '{}', skipping it.", new Object[]{key, bucket, e});
            }
        }
        return documents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Region region;
        private TencentCredentials tencentCredentials;

        public Builder region(String region) {
            this.region = new Region(Region.formatRegion((String)region));
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder tencentCredentials(TencentCredentials tencentCredentials) {
            this.tencentCredentials = tencentCredentials;
            return this;
        }

        public TencentCosDocumentLoader build() {
            COSCredentialsProvider credentialsProvider = this.createCredentialsProvider();
            COSClient cosClient = this.createCosClient(credentialsProvider);
            return new TencentCosDocumentLoader(cosClient);
        }

        private COSCredentialsProvider createCredentialsProvider() {
            ValidationUtils.ensureNotNull((Object)this.tencentCredentials, (String)"%s", (Object[])new Object[]{"Tencent credentials are required."});
            return this.tencentCredentials.toCredentialsProvider();
        }

        private COSClient createCosClient(COSCredentialsProvider cosCredentialsProvider) {
            ClientConfig clientConfig = new ClientConfig(this.region);
            return new COSClient(cosCredentialsProvider, clientConfig);
        }
    }
}

