/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.selenium;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumDocumentLoader {
    private static final Logger logger = LoggerFactory.getLogger(SeleniumDocumentLoader.class);
    private static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(30L);
    private final WebDriver webDriver;
    private final Duration timeout;

    private SeleniumDocumentLoader(WebDriver webDriver, Duration timeout) {
        this.webDriver = webDriver;
        this.timeout = timeout;
    }

    public Document load(String url, DocumentParser documentParser) {
        String pageContent;
        logger.info("Loading document from URL: {}", (Object)url);
        try {
            this.webDriver.get(url);
            WebDriverWait wait = new WebDriverWait(this.webDriver, this.timeout);
            logger.debug("Waiting webpage fully loaded: {}", (Object)url);
            wait.until((Function)((ExpectedCondition)wd -> {
                if (logger.isTraceEnabled()) {
                    logger.trace("Waiting for document.readyState to be complete");
                }
                return ((JavascriptExecutor)Objects.requireNonNull(wd)).executeScript("return document.readyState", new Object[0]).equals("complete");
            }));
            pageContent = this.webDriver.getPageSource();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load document", e);
        }
        Document parsedDocument = documentParser.parse((InputStream)new ByteArrayInputStream(pageContent.getBytes()));
        parsedDocument.metadata().put("url", url);
        return parsedDocument;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_TIMEOUT_DURATION;
    }

    public static class Builder {
        private WebDriver webDriver;
        private Duration timeout = SeleniumDocumentLoader.access$000();

        public Builder webDriver(WebDriver webDriver) {
            this.webDriver = webDriver;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public SeleniumDocumentLoader build() {
            Objects.requireNonNull(this.webDriver, "webDriver must be set");
            return new SeleniumDocumentLoader(this.webDriver, this.timeout);
        }
    }
}

