/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding.listener;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Map;

@Experimental
public class EmbeddingModelResponseContext {
    private final Response<List<Embedding>> response;
    private final List<TextSegment> textSegments;
    private final EmbeddingModel embeddingModel;
    private final Map<Object, Object> attributes;

    public EmbeddingModelResponseContext(Builder builder) {
        this.response = ValidationUtils.ensureNotNull(builder.response, "response");
        this.textSegments = Utils.copy(ValidationUtils.ensureNotNull(builder.textSegments, "textSegments"));
        this.embeddingModel = ValidationUtils.ensureNotNull(builder.embeddingModel, "embeddingModel");
        this.attributes = ValidationUtils.ensureNotNull(builder.attributes, "attributes");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Response<List<Embedding>> response() {
        return this.response;
    }

    public List<TextSegment> textSegments() {
        return this.textSegments;
    }

    public EmbeddingModel embeddingModel() {
        return this.embeddingModel;
    }

    public Map<Object, Object> attributes() {
        return this.attributes;
    }

    @Experimental
    public static class Builder {
        private Response<List<Embedding>> response;
        private List<TextSegment> textSegments;
        private EmbeddingModel embeddingModel;
        private Map<Object, Object> attributes;

        Builder() {
        }

        public Builder response(Response<List<Embedding>> response) {
            this.response = response;
            return this;
        }

        public Builder textSegments(List<TextSegment> textSegments) {
            this.textSegments = textSegments;
            return this;
        }

        public Builder embeddingModel(EmbeddingModel embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this;
        }

        public Builder attributes(Map<Object, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public EmbeddingModelResponseContext build() {
            return new EmbeddingModelResponseContext(this);
        }
    }
}

