/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.Internal;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModelListenerUtils;
import dev.langchain4j.model.embedding.listener.EmbeddingModelErrorContext;
import dev.langchain4j.model.embedding.listener.EmbeddingModelListener;
import dev.langchain4j.model.embedding.listener.EmbeddingModelRequestContext;
import dev.langchain4j.model.embedding.listener.EmbeddingModelResponseContext;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@Internal
final class ListeningEmbeddingModel
implements EmbeddingModel {
    private final EmbeddingModel delegate;
    private final List<EmbeddingModelListener> listeners;

    ListeningEmbeddingModel(EmbeddingModel delegate, List<EmbeddingModelListener> listeners) {
        this.delegate = ValidationUtils.ensureNotNull(delegate, "delegate");
        this.listeners = Utils.copy(listeners);
    }

    EmbeddingModel withAdditionalListeners(List<EmbeddingModelListener> additionalListeners) {
        if (additionalListeners == null || additionalListeners.isEmpty()) {
            return this;
        }
        ArrayList<EmbeddingModelListener> merged = new ArrayList<EmbeddingModelListener>(this.listeners);
        merged.addAll(additionalListeners);
        return new ListeningEmbeddingModel(this.delegate, merged);
    }

    @Override
    public Response<Embedding> embed(String text) {
        List<TextSegment> textSegmentsForContext;
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        try {
            textSegmentsForContext = List.of(TextSegment.from(text));
        }
        catch (Exception ignored) {
            textSegmentsForContext = List.of();
        }
        EmbeddingModelRequestContext requestContext = EmbeddingModelRequestContext.builder().textSegments(textSegmentsForContext).embeddingModel(this).attributes(attributes).build();
        EmbeddingModelListenerUtils.onRequest(requestContext, this.listeners);
        try {
            Response<Embedding> response = this.delegate.embed(text);
            Response<List<Embedding>> responseForListeners = Response.from(Collections.singletonList(response.content()), response.tokenUsage(), response.finishReason());
            EmbeddingModelListenerUtils.onResponse(EmbeddingModelResponseContext.builder().response(responseForListeners).textSegments(textSegmentsForContext).embeddingModel(this).attributes(attributes).build(), this.listeners);
            return response;
        }
        catch (Exception error) {
            EmbeddingModelListenerUtils.onError(EmbeddingModelErrorContext.builder().error(error).textSegments(textSegmentsForContext).embeddingModel(this).attributes(attributes).build(), this.listeners);
            throw error;
        }
    }

    @Override
    public Response<Embedding> embed(TextSegment textSegment) {
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        List<TextSegment> textSegmentsForContext = textSegment == null ? List.of() : List.of(textSegment);
        EmbeddingModelRequestContext requestContext = EmbeddingModelRequestContext.builder().textSegments(textSegmentsForContext).embeddingModel(this).attributes(attributes).build();
        EmbeddingModelListenerUtils.onRequest(requestContext, this.listeners);
        try {
            Response<Embedding> response = this.delegate.embed(textSegment);
            Response<List<Embedding>> responseForListeners = Response.from(Collections.singletonList(response.content()), response.tokenUsage(), response.finishReason());
            EmbeddingModelListenerUtils.onResponse(EmbeddingModelResponseContext.builder().response(responseForListeners).textSegments(textSegmentsForContext).embeddingModel(this).attributes(attributes).build(), this.listeners);
            return response;
        }
        catch (Exception error) {
            EmbeddingModelListenerUtils.onError(EmbeddingModelErrorContext.builder().error(error).textSegments(textSegmentsForContext).embeddingModel(this).attributes(attributes).build(), this.listeners);
            throw error;
        }
    }

    @Override
    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        EmbeddingModelRequestContext requestContext = EmbeddingModelRequestContext.builder().textSegments(textSegments).embeddingModel(this).attributes(attributes).build();
        EmbeddingModelListenerUtils.onRequest(requestContext, this.listeners);
        try {
            Response<List<Embedding>> response = this.delegate.embedAll(textSegments);
            EmbeddingModelListenerUtils.onResponse(EmbeddingModelResponseContext.builder().response(response).textSegments(textSegments).embeddingModel(this).attributes(attributes).build(), this.listeners);
            return response;
        }
        catch (Exception error) {
            EmbeddingModelListenerUtils.onError(EmbeddingModelErrorContext.builder().error(error).textSegments(textSegments).embeddingModel(this).attributes(attributes).build(), this.listeners);
            throw error;
        }
    }

    @Override
    public String modelName() {
        return this.delegate.modelName();
    }
}

