/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.ListeningEmbeddingModel;
import dev.langchain4j.model.embedding.listener.EmbeddingModelListener;
import dev.langchain4j.model.output.Response;
import java.util.Collections;
import java.util.List;

public interface EmbeddingModel {
    default public Response<Embedding> embed(String text) {
        return this.embed(TextSegment.from(text));
    }

    default public Response<Embedding> embed(TextSegment textSegment) {
        Response<List<Embedding>> response = this.embedAll(Collections.singletonList(textSegment));
        ValidationUtils.ensureEq(response.content().size(), 1, "Expected a single embedding, but got %d", response.content().size());
        return Response.from(response.content().get(0), response.tokenUsage(), response.finishReason());
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> var1);

    default public int dimension() {
        return this.embed("test").content().dimension();
    }

    default public String modelName() {
        return "unknown";
    }

    @Experimental
    default public EmbeddingModel addListener(EmbeddingModelListener listener) {
        return this.addListeners(listener == null ? null : List.of(listener));
    }

    @Experimental
    default public EmbeddingModel addListeners(List<EmbeddingModelListener> listeners) {
        if (Utils.isNullOrEmpty(listeners)) {
            return this;
        }
        EmbeddingModel embeddingModel = this;
        if (embeddingModel instanceof ListeningEmbeddingModel) {
            ListeningEmbeddingModel listeningEmbeddingModel = (ListeningEmbeddingModel)embeddingModel;
            return listeningEmbeddingModel.withAdditionalListeners(listeners);
        }
        return new ListeningEmbeddingModel(this, listeners);
    }
}

