/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class ToolExecutionResultMessage
implements ChatMessage {
    private final String id;
    private final String toolName;
    private final String text;
    private final Boolean isError;

    public ToolExecutionResultMessage(Builder builder) {
        this.id = builder.id;
        this.toolName = builder.toolName;
        this.text = ValidationUtils.ensureNotNull(builder.text, "text");
        this.isError = builder.isError;
    }

    public ToolExecutionResultMessage(String id, String toolName, String text) {
        this.id = id;
        this.toolName = toolName;
        this.text = ValidationUtils.ensureNotNull(text, "text");
        this.isError = null;
    }

    public String id() {
        return this.id;
    }

    public String toolName() {
        return this.toolName;
    }

    public String text() {
        return this.text;
    }

    public Boolean isError() {
        return this.isError;
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.TOOL_EXECUTION_RESULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolExecutionResultMessage that = (ToolExecutionResultMessage)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.toolName, that.toolName) && Objects.equals(this.text, that.text) && Objects.equals(this.isError, that.isError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.toolName, this.text, this.isError);
    }

    public String toString() {
        return "ToolExecutionResultMessage { id = " + Utils.quoted(this.id) + " toolName = " + Utils.quoted(this.toolName) + " text = " + Utils.quoted(this.text) + " isError = " + this.isError + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ToolExecutionResultMessage from(ToolExecutionRequest request, String toolExecutionResult) {
        return new ToolExecutionResultMessage(request.id(), request.name(), toolExecutionResult);
    }

    public static ToolExecutionResultMessage from(String id, String toolName, String toolExecutionResult) {
        return new ToolExecutionResultMessage(id, toolName, toolExecutionResult);
    }

    public static ToolExecutionResultMessage toolExecutionResultMessage(ToolExecutionRequest request, String toolExecutionResult) {
        return ToolExecutionResultMessage.from(request, toolExecutionResult);
    }

    public static ToolExecutionResultMessage toolExecutionResultMessage(String id, String toolName, String toolExecutionResult) {
        return ToolExecutionResultMessage.from(id, toolName, toolExecutionResult);
    }

    public static class Builder {
        private String id;
        private String toolName;
        private String text;
        private Boolean isError;

        @JsonProperty(value="id")
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="toolName")
        public Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        @JsonProperty(value="text")
        public Builder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="isError")
        public Builder isError(Boolean isError) {
            this.isError = isError;
            return this;
        }

        public ToolExecutionResultMessage build() {
            return new ToolExecutionResultMessage(this);
        }
    }
}

