/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.invocation.LangChain4jManaged;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ToolSpecifications {
    private static final Type MAP_TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, Object.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };

    private ToolSpecifications() {
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Class<?> classWithTools) {
        List<ToolSpecification> toolSpecifications = Arrays.stream(classWithTools.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(ToolSpecifications::toolSpecificationFrom).collect(Collectors.toList());
        ToolSpecifications.validateSpecifications(toolSpecifications);
        return toolSpecifications;
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Object objectWithTools) {
        return ToolSpecifications.toolSpecificationsFrom(objectWithTools.getClass());
    }

    public static void validateSpecifications(List<ToolSpecification> toolSpecifications) throws IllegalArgumentException {
        HashSet<String> names = new HashSet<String>();
        for (ToolSpecification toolSpecification : toolSpecifications) {
            if (names.add(toolSpecification.name())) continue;
            throw new IllegalArgumentException(String.format("Tool names must be unique. The tool '%s' appears several times", toolSpecification.name()));
        }
    }

    public static ToolSpecification toolSpecificationFrom(Method method) {
        Tool tool = method.getAnnotation(Tool.class);
        return ToolSpecification.builder().name(ToolSpecifications.getName(tool, method)).description(ToolSpecifications.getDescription(tool)).parameters(ToolSpecifications.parametersFrom(method.getParameters())).metadata(ToolSpecifications.getMetadata(tool)).build();
    }

    private static String getName(Tool tool, Method method) {
        return Utils.isNullOrBlank(tool.name()) ? method.getName() : tool.name();
    }

    private static String getDescription(Tool tool) {
        String description = String.join((CharSequence)"\n", tool.value());
        return description.isEmpty() ? null : description;
    }

    private static Map<String, Object> getMetadata(Tool annotation) {
        return (Map)Json.fromJson(annotation.metadata(), MAP_TYPE);
    }

    private static JsonObjectSchema parametersFrom(Parameter[] parameters) {
        LinkedHashMap<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        ArrayList<String> required = new ArrayList<String>();
        LinkedHashMap visited = new LinkedHashMap();
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(ToolMemoryId.class) || InvocationParameters.class.isAssignableFrom(parameter.getType()) || LangChain4jManaged.class.isAssignableFrom(parameter.getType()) || parameter.getType() == InvocationContext.class) continue;
            boolean isRequired = Optional.ofNullable(parameter.getAnnotation(P.class)).map(P::required).orElse(true);
            properties.put(parameter.getName(), ToolSpecifications.jsonSchemaElementFrom(parameter, visited));
            if (!isRequired) continue;
            required.add(parameter.getName());
        }
        LinkedHashMap<String, JsonSchemaElement> definitions = new LinkedHashMap<String, JsonSchemaElement>();
        visited.forEach((clazz, visitedClassMetadata) -> {
            if (visitedClassMetadata.recursionDetected) {
                definitions.put(visitedClassMetadata.reference, visitedClassMetadata.jsonSchemaElement);
            }
        });
        if (properties.isEmpty()) {
            return null;
        }
        return JsonObjectSchema.builder().addProperties(properties).required(required).definitions(definitions.isEmpty() ? null : definitions).build();
    }

    private static JsonSchemaElement jsonSchemaElementFrom(Parameter parameter, Map<Class<?>, JsonSchemaElementUtils.VisitedClassMetadata> visited) {
        P annotation = parameter.getAnnotation(P.class);
        String description = annotation == null ? null : annotation.value();
        return JsonSchemaElementUtils.jsonSchemaElementFrom(parameter.getType(), parameter.getParameterizedType(), description, true, visited);
    }
}

