/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.store.embedding.filter.MetadataFilterBuilder;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FilterTest {
    FilterTest() {
    }

    @Test
    void test_in_string() {
        Metadata metadata = new Metadata().put("id", "1");
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"1"}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Collections.singletonList("1")).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"1", "2"}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Arrays.asList("1", "2")).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"2"}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"2", "3"}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{1}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1) has type java.lang.String, while comparison value (1) has type java.lang.Integer");
    }

    @Test
    void test_not_in_string() {
        Metadata metadata = new Metadata().put("id", "1");
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"2"}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Collections.singletonList("2")).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"2", "3"}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Arrays.asList("2", "3")).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"1"}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"1", "2"}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{1}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1) has type java.lang.String, while comparison value (1) has type java.lang.Integer");
    }

    @Test
    void test_in_integer() {
        Metadata metadata = new Metadata().put("id", 1);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{1}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Collections.singletonList(1)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{1, 2}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Arrays.asList(1, 2)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{1L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{1.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{1.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{2}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{2, 3}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1) has type java.lang.Integer, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_not_in_integer() {
        Metadata metadata = new Metadata().put("id", 1);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{2}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Collections.singletonList(2)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{2, 3}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Arrays.asList(2, 3)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{1}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{1, 2}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{1L}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{1.0f}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{1.0}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1) has type java.lang.Integer, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_in_long() {
        Metadata metadata = new Metadata().put("id", 1L);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{1L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Collections.singletonList(1L)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{1L, 2L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Arrays.asList(1L, 2L)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{1}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{1.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{1.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{2L}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{2L, 3L}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1) has type java.lang.Long, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_not_in_long() {
        Metadata metadata = new Metadata().put("id", 1L);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{2L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Collections.singletonList(2L)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{2L, 3L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Arrays.asList(2L, 3L)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{1L}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{1L, 2L}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{1}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{1.0f}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{1.0}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1) has type java.lang.Long, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_in_float() {
        Metadata metadata = new Metadata().put("id", 1.0f);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{1.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Collections.singletonList(Float.valueOf(1.0f))).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{1.0f, 2.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f))).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{1}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{1L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{1.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{2.0f}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{2.0f, 3.0f}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1.0) has type java.lang.Float, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_not_in_float() {
        Metadata metadata = new Metadata().put("id", 1.0f);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{2.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Collections.singletonList(Float.valueOf(2.0f))).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{2.0f, 3.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Arrays.asList(Float.valueOf(2.0f), Float.valueOf(3.0f))).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{1.0f}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{1.0f, 2.0f}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{1}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{1L}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{1.0}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1.0) has type java.lang.Float, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_in_double() {
        Metadata metadata = new Metadata().put("id", 1.0);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{1.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Collections.singletonList(1.0)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{1.0, 2.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(Arrays.asList(1.0, 2.0)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new int[]{1}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new long[]{1L}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new float[]{1.0f}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{2.0}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isIn(new double[]{2.0, 3.0}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1.0) has type java.lang.Double, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_not_in_double() {
        Metadata metadata = new Metadata().put("id", 1.0);
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{2.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Collections.singletonList(2.0)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{2.0, 3.0}).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Arrays.asList(2.0, 3.0)).test((Object)metadata)).isTrue();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{1.0}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new double[]{1.0, 2.0}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new int[]{1}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new long[]{1L}).test((Object)metadata)).isFalse();
        Assertions.assertThat((boolean)MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new float[]{1.0f}).test((Object)metadata)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(new String[]{"1"}).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Type mismatch: actual value of metadata key \"id\" (1.0) has type java.lang.Double, while comparison value (1) has type java.lang.String");
    }

    @Test
    void test_in_empty_list() {
        Metadata metadata = new Metadata().put("id", 1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(Collections.emptyList()).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("comparisonValues with key 'id' cannot be null or empty");
    }

    @Test
    void test_in_list_with_null() {
        Metadata metadata = new Metadata().put("id", 1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isIn(Arrays.asList(1, null)).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("comparisonValue with key 'id' cannot be null");
    }

    @Test
    void test_not_in_empty_list() {
        Metadata metadata = new Metadata().put("id", 1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Collections.emptyList()).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("comparisonValues with key 'id' cannot be null or empty");
    }

    @Test
    void test_not_in_list_with_null() {
        Metadata metadata = new Metadata().put("id", 1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataFilterBuilder.metadataKey((String)"id").isNotIn(Arrays.asList(1, null)).test((Object)metadata)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("comparisonValue with key 'id' cannot be null");
    }
}

