/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.retriever;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.rag.content.retriever.EmbeddingStoreContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.MetadataFilterBuilder;
import java.util.Arrays;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class EmbeddingStoreContentRetrieverTest {
    private static EmbeddingStore<TextSegment> EMBEDDING_STORE;
    private static EmbeddingModel EMBEDDING_MODEL;
    private static final Embedding EMBEDDING;
    private static final Query QUERY;
    private static final int DEFAULT_MAX_RESULTS = 3;
    private static final int CUSTOM_MAX_RESULTS = 1;
    private static final double CUSTOM_MIN_SCORE = 0.7;
    public static final double DEFAULT_MIN_SCORE = 0.0;

    EmbeddingStoreContentRetrieverTest() {
    }

    @BeforeEach
    void beforeEach() {
        EMBEDDING_STORE = (EmbeddingStore)Mockito.mock(EmbeddingStore.class);
        Mockito.when((Object)EMBEDDING_STORE.search((EmbeddingSearchRequest)ArgumentMatchers.any())).thenReturn((Object)new EmbeddingSearchResult(Arrays.asList(new EmbeddingMatch(Double.valueOf(0.9), "id 1", null, (Object)TextSegment.from((String)"content 1")), new EmbeddingMatch(Double.valueOf(0.7), "id 2", null, (Object)TextSegment.from((String)"content 2")))));
        EMBEDDING_MODEL = (EmbeddingModel)Mockito.mock(EmbeddingModel.class);
        Mockito.when((Object)EMBEDDING_MODEL.embed(ArgumentMatchers.anyString())).thenReturn((Object)Response.from((Object)EMBEDDING));
    }

    @AfterEach
    void afterEach() {
        ((EmbeddingModel)Mockito.verify((Object)EMBEDDING_MODEL)).embed(QUERY.text());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_MODEL});
    }

    @Test
    void should_retrieve() {
        EmbeddingStoreContentRetriever contentRetriever = new EmbeddingStoreContentRetriever(EMBEDDING_STORE, EMBEDDING_MODEL);
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.0)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_builder() {
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.0)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_maxResults() {
        EmbeddingStoreContentRetriever contentRetriever = new EmbeddingStoreContentRetriever(EMBEDDING_STORE, EMBEDDING_MODEL, 1);
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(1)).minScore(Double.valueOf(0.0)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_maxResults_builder() {
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).maxResults(Integer.valueOf(1)).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(1)).minScore(Double.valueOf(0.0)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_dynamicMaxResults_builder() {
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).dynamicMaxResults(query -> 1).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(1)).minScore(Double.valueOf(0.0)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_minScore_ctor() {
        EmbeddingStoreContentRetriever contentRetriever = new EmbeddingStoreContentRetriever(EMBEDDING_STORE, EMBEDDING_MODEL, null, Double.valueOf(0.7));
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.7)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_minScore_builder() {
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).minScore(Double.valueOf(0.7)).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.7)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_dynamicMinScore_builder() {
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).dynamicMinScore(query -> 0.7).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.7)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_filter() {
        Filter metadataFilter = MetadataFilterBuilder.metadataKey((String)"key").isEqualTo("value");
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).filter(metadataFilter).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.0)).filter(metadataFilter).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    @Test
    void should_retrieve_with_custom_dynamicFilter() {
        Filter metadataFilter = MetadataFilterBuilder.metadataKey((String)"key").isEqualTo("value");
        EmbeddingStoreContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder().embeddingStore(EMBEDDING_STORE).embeddingModel(EMBEDDING_MODEL).dynamicFilter(query -> metadataFilter).build();
        contentRetriever.retrieve(QUERY);
        ((EmbeddingStore)Mockito.verify(EMBEDDING_STORE)).search(EmbeddingSearchRequest.builder().queryEmbedding(EMBEDDING).maxResults(Integer.valueOf(3)).minScore(Double.valueOf(0.0)).filter(metadataFilter).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{EMBEDDING_STORE});
    }

    static {
        EMBEDDING = Embedding.from(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)));
        QUERY = Query.from((String)"query");
    }
}

