/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input.structured;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.DefaultStructuredPromptFactory;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class DefaultStructuredPromptFactoryTest
implements WithAssertions {
    DefaultStructuredPromptFactoryTest() {
    }

    @Test
    public void test() {
        DefaultStructuredPromptFactory factory = new DefaultStructuredPromptFactory();
        Prompt p = factory.toPrompt((Object)new Greeting("Klaus"));
        this.assertThat(p.text()).isEqualTo("Hello, my name is Klaus");
    }

    @Test
    public void test_bad_input() {
        DefaultStructuredPromptFactory factory = new DefaultStructuredPromptFactory();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> factory.toPrompt(null)).withMessage("structuredPrompt cannot be null");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> factory.toPrompt(new Object())).withMessage("java.lang.Object should be annotated with @StructuredPrompt to be used as a structured prompt");
    }

    @Test
    public void test_brokenPrompt() {
        DefaultStructuredPromptFactory factory = new DefaultStructuredPromptFactory();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> factory.toPrompt((Object)new BrokenPrompt("Klaus"))).withMessage("Value for the variable 'broken' is missing");
    }

    @StructuredPrompt(value={"Hello, my name is {{name}}"})
    static class Greeting {
        public final String name;

        public Greeting(String name) {
            this.name = name;
        }
    }

    @StructuredPrompt(value={"Hello, my name is {{broken}}"})
    static class BrokenPrompt {
        public final String name;

        public BrokenPrompt(String name) {
            this.name = name;
        }
    }
}

