/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import java.util.ArrayList;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TokenCountEstimatorTest
implements WithAssertions {
    TokenCountEstimatorTest() {
    }

    @Test
    public void test() {
        WhitespaceSplitTokenCountEstimator estimator = new WhitespaceSplitTokenCountEstimator();
        this.assertThat(estimator.estimateTokenCount("foo bar, baz")).isEqualTo(3);
        this.assertThat(estimator.estimateTokenCount(TextSegment.textSegment((String)"foo bar, baz"))).isEqualTo(3);
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        segments.add(TextSegment.textSegment((String)"Hello, world!"));
        segments.add(TextSegment.textSegment((String)"How are you?"));
        this.assertThat(estimator.estimateTokenCount(segments)).isEqualTo(5);
    }

    public static class WhitespaceSplitTokenCountEstimator
    implements TokenCountEstimator {
        public int estimateTokenCount(String text) {
            return text.split("\\s+").length;
        }
    }
}

