/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ChatLanguageModelTest
implements WithAssertions {
    ChatLanguageModelTest() {
    }

    @Test
    public void test_not_supported() {
        UpperCaseEchoModel model = new UpperCaseEchoModel();
        ArrayList messages = new ArrayList();
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> model.generate(messages, new ArrayList())).withMessageContaining("Tools are currently not supported by this model");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> model.generate(messages, ToolSpecification.builder().name("foo").build())).withMessageContaining("Tools are currently not supported by this model");
    }

    @Test
    public void test_generate() {
        UpperCaseEchoModel model = new UpperCaseEchoModel();
        this.assertThat(model.generate("how are you?")).isEqualTo("HOW ARE YOU?");
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(new UserMessage("Hello"));
        messages.add(new AiMessage("Hi"));
        messages.add(new UserMessage("How are you?"));
        Response response = model.generate(messages);
        this.assertThat(((AiMessage)response.content()).text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response.tokenUsage()).isNull();
        this.assertThat((Comparable)response.finishReason()).isNull();
        Response response2 = model.generate(new ChatMessage[]{new UserMessage("Hello"), new AiMessage("Hi"), new UserMessage("How are you?")});
        this.assertThat(((AiMessage)response2.content()).text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response2.tokenUsage()).isNull();
        this.assertThat((Comparable)response2.finishReason()).isNull();
    }

    public static class UpperCaseEchoModel
    implements ChatLanguageModel {
        public Response<AiMessage> generate(List<ChatMessage> messages) {
            ChatMessage lastMessage = messages.get(messages.size() - 1);
            return new Response((Object)new AiMessage(lastMessage.text().toUpperCase(Locale.ROOT)));
        }
    }
}

