/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.Tokenizer;

public class ExampleTestTokenizer
implements Tokenizer {
    public int estimateTokenCountInText(String text) {
        return text.split(" ").length;
    }

    public int estimateTokenCountInMessage(ChatMessage message) {
        return this.estimateTokenCountInText(message.text());
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        int tokenCount = 0;
        for (ChatMessage message : messages) {
            tokenCount += this.estimateTokenCountInMessage(message);
        }
        return tokenCount;
    }

    public int estimateTokenCountInToolSpecifications(Iterable<ToolSpecification> toolSpecifications) {
        int tokenCount = 0;
        for (ToolSpecification specification : toolSpecifications) {
            tokenCount += this.estimateTokenCountInText(specification.description());
        }
        return tokenCount;
    }

    public int estimateTokenCountInToolExecutionRequests(Iterable<ToolExecutionRequest> toolExecutionRequests) {
        int tokenCount = 0;
        for (ToolExecutionRequest request : toolExecutionRequests) {
            tokenCount += this.estimateTokenCountInText(request.arguments());
        }
        return tokenCount;
    }
}

