/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Metadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class MetadataTest
implements WithAssertions {
    MetadataTest() {
    }

    @Test
    public void test_add_get_put() {
        Metadata m = new Metadata();
        this.assertThat(m.get("foo")).isNull();
        m.add("foo", "bar");
        this.assertThat(m.get("foo")).isEqualTo("bar");
        m.add("xyz", (Object)2);
        this.assertThat(m.get("xyz")).isEqualTo("2");
    }

    @Test
    public void test_map_constructor_copies() {
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("foo", "bar");
        Metadata m = new Metadata(source);
        HashMap sourceCopy = new HashMap(source);
        source.put("baz", "qux");
        this.assertThat(m.asMap()).isEqualTo(sourceCopy);
    }

    @Test
    public void test_toString() {
        Metadata m = new Metadata();
        m.add("foo", "bar");
        m.add("baz", "qux");
        this.assertThat(m.toString()).isEqualTo("Metadata { metadata = {foo=bar, baz=qux} }");
    }

    @Test
    public void test_equals_hash() {
        Metadata m1 = new Metadata();
        Metadata m2 = new Metadata();
        m1.add("foo", "bar");
        m2.add("foo", "bar");
        Metadata m3 = new Metadata();
        Metadata m4 = new Metadata();
        m3.add("different", "value");
        m4.add("different", "value");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(m1).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)m2)).hasSameHashCodeAs((Object)m2);
        ((ObjectAssert)this.assertThat(m1).isNotEqualTo((Object)m3)).doesNotHaveSameHashCodeAs((Object)m3);
        ((ObjectAssert)this.assertThat(m3).isEqualTo((Object)m4)).hasSameHashCodeAs((Object)m4);
    }

    @Test
    public void test_copy() {
        Metadata m1 = new Metadata();
        m1.add("foo", "bar");
        Metadata m2 = m1.copy();
        this.assertThat(m1).isEqualTo((Object)m2);
        m1.add("foo", "baz");
        this.assertThat(m1).isNotEqualTo((Object)m2);
    }

    @Test
    public void test_builders() {
        HashMap emptyMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        map.put("baz", "qux");
        this.assertThat(new Metadata()).isEqualTo((Object)new Metadata(emptyMap));
        this.assertThat(Metadata.from(map)).isEqualTo((Object)new Metadata().add("foo", "bar").add("baz", "qux"));
        this.assertThat(Metadata.from((String)"foo", (String)"bar")).isEqualTo((Object)new Metadata().add("foo", "bar"));
        this.assertThat(Metadata.metadata((String)"foo", (String)"bar")).isEqualTo((Object)new Metadata().add("foo", "bar"));
        this.assertThat(Metadata.from((String)"foo", (Object)2)).isEqualTo((Object)new Metadata().add("foo", "2"));
        this.assertThat(Metadata.metadata((String)"foo", (Object)2)).isEqualTo((Object)new Metadata().add("foo", "2"));
    }

    @Test
    public void test_remove() {
        Metadata m1 = new Metadata();
        m1.add("foo", "bar");
        m1.add("baz", "qux");
        this.assertThat(m1.remove("foo")).isSameAs((Object)m1);
        this.assertThat(m1).isEqualTo((Object)new Metadata().add("baz", "qux"));
    }

    @Test
    void test_asMap() {
        Metadata metadata = Metadata.from((String)"key", (String)"value");
        Map map = metadata.asMap();
        ((MapAssert)this.assertThat(map).containsKey((Object)"key")).containsValue((Object)"value");
    }

    @Test
    void test_create_from_map() {
        Map<String, String> map = Collections.singletonMap("key", "value");
        Metadata metadata = Metadata.from(map);
        this.assertThat(metadata.get("key")).isEqualTo("value");
    }

    @Test
    void should_create_from_map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("string", "s");
        map.put("integer", 1);
        map.put("integer_as_string", "1");
        map.put("integer_as_long", 1L);
        map.put("integer_as_float", Float.valueOf(1.0f));
        map.put("integer_as_double", 1.0);
        map.put("long", 1L);
        map.put("long_as_string", "1");
        map.put("long_as_integer", 1);
        map.put("long_as_float", Float.valueOf(1.0f));
        map.put("long_as_double", 1.0);
        map.put("float", Float.valueOf(1.0f));
        map.put("float_as_string", "1");
        map.put("float_as_integer", 1);
        map.put("float_as_long", 1L);
        map.put("float_as_double", 1.0);
        map.put("double", 1.0);
        map.put("double_as_string", "1");
        map.put("double_as_integer", 1);
        map.put("double_as_long", 1L);
        map.put("double_as_float", Float.valueOf(1.0f));
        Metadata metadata = new Metadata(map);
        this.assertThat(metadata.getString("string")).isEqualTo("s");
        this.assertThat(metadata.getString("banana")).isNull();
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.getString("integer")).isExactlyInstanceOf(RuntimeException.class)).hasMessage("Metadata entry with the key 'integer' has a value of '1' and type 'java.lang.Integer'. It cannot be returned as a String.");
        this.assertThat(metadata.getInteger("integer")).isEqualTo(1);
        this.assertThat(metadata.getInteger("integer_as_string")).isEqualTo(1);
        this.assertThat(metadata.getInteger("integer_as_long")).isEqualTo(1);
        this.assertThat(metadata.getInteger("integer_as_float")).isEqualTo(1);
        this.assertThat(metadata.getInteger("integer_as_double")).isEqualTo(1);
        this.assertThat(metadata.getInteger("banana")).isNull();
        this.assertThat(metadata.getLong("long")).isEqualTo(1L);
        this.assertThat(metadata.getLong("long_as_string")).isEqualTo(1L);
        this.assertThat(metadata.getLong("long_as_integer")).isEqualTo(1L);
        this.assertThat(metadata.getLong("long_as_float")).isEqualTo(1L);
        this.assertThat(metadata.getLong("long_as_double")).isEqualTo(1L);
        this.assertThat(metadata.getLong("banana")).isNull();
        this.assertThat(metadata.getFloat("float")).isEqualTo(1.0f);
        this.assertThat(metadata.getFloat("float_as_string")).isEqualTo(1.0f);
        this.assertThat(metadata.getFloat("float_as_integer")).isEqualTo(1.0f);
        this.assertThat(metadata.getFloat("float_as_long")).isEqualTo(1.0f);
        this.assertThat(metadata.getFloat("float_as_double")).isEqualTo(1.0f);
        this.assertThat(metadata.getFloat("banana")).isNull();
        this.assertThat(metadata.getDouble("double")).isEqualTo(1.0);
        this.assertThat(metadata.getDouble("double_as_string")).isEqualTo(1.0);
        this.assertThat(metadata.getDouble("double_as_integer")).isEqualTo(1.0);
        this.assertThat(metadata.getDouble("double_as_long")).isEqualTo(1.0);
        this.assertThat(metadata.getDouble("double_as_float")).isEqualTo(1.0);
        this.assertThat(metadata.getDouble("banana")).isNull();
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(strings={"", " "})
    void should_fail_to_create_from_map_when_key_is_null(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, "value");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> new Metadata(map)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value 'value' cannot be null or blank");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> Metadata.from((Map)map)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value 'value' cannot be null or blank");
    }

    @Test
    void should_fail_to_create_from_map_when_value_is_null() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", null);
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> new Metadata(map)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata value for the key 'key' cannot be null");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> Metadata.from((Map)map)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata value for the key 'key' cannot be null");
    }

    @Test
    void should_fail_to_create_from_map_when_value_is_of_unsupported_type() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", new Object());
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> new Metadata(map)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("The metadata key 'key' has the value").hasMessageEndingWith("which is of the unsupported type 'java.lang.Object'. Currently, the supported types are: [class java.lang.String, int, class java.lang.Integer, long, class java.lang.Long, float, class java.lang.Float, double, class java.lang.Double]");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> Metadata.from((Map)map)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("The metadata key 'key' has the value").hasMessageEndingWith("which is of the unsupported type 'java.lang.Object'. Currently, the supported types are: [class java.lang.String, int, class java.lang.Integer, long, class java.lang.Long, float, class java.lang.Float, double, class java.lang.Double]");
    }

    @Test
    void should_get_typed_values() {
        Metadata metadata = new Metadata().put("string", "s").put("integer", 1).put("long", 1L).put("float", 1.0f).put("double", 1.0);
        this.assertThat(metadata.getString("string")).isEqualTo("s");
        this.assertThat(metadata.getString("banana")).isNull();
        this.assertThat(metadata.getInteger("integer")).isEqualTo(1);
        this.assertThat(metadata.getInteger("banana")).isNull();
        this.assertThat(metadata.getLong("long")).isEqualTo(1L);
        this.assertThat(metadata.getLong("banana")).isNull();
        this.assertThat(metadata.getFloat("float")).isEqualTo(1.0f);
        this.assertThat(metadata.getFloat("banana")).isNull();
        this.assertThat(metadata.getDouble("double")).isEqualTo(1.0);
        this.assertThat(metadata.getDouble("banana")).isNull();
    }

    @Test
    void should_fail_when_adding_null_key() {
        Metadata metadata = new Metadata();
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.put(null, "value")).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value 'value' cannot be null or blank");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.put(null, 1)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value '1' cannot be null or blank");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.put(null, 1L)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value '1' cannot be null or blank");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.put(null, 1.0f)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value '1.0' cannot be null or blank");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.put(null, 1.0)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata key with the value '1.0' cannot be null or blank");
    }

    @Test
    void should_fail_when_adding_null_value() {
        Metadata metadata = new Metadata();
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> metadata.put("key", null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The metadata value for the key 'key' cannot be null");
    }

    @Test
    void should_convert_to_map() {
        HashMap<String, Object> originalMap = new HashMap<String, Object>();
        originalMap.put("string", "s");
        originalMap.put("integer", 1);
        originalMap.put("long", 1L);
        originalMap.put("float", Float.valueOf(1.0f));
        originalMap.put("double", 1.0);
        Metadata metadata = Metadata.from(originalMap);
        Map map = metadata.toMap();
        this.assertThat(map).isEqualTo(originalMap);
    }

    @Test
    void test_containsKey() {
        this.assertThat(new Metadata().containsKey("key")).isFalse();
        this.assertThat(new Metadata().add("key", "value").containsKey("key")).isTrue();
    }
}

