/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class DocumentLoaderTest
implements WithAssertions {
    DocumentLoaderTest() {
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        IOException exception = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readLen;
                while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    exception = e;
                    throw e;
                }
            }
            outputStream.close();
            return byArray;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    @Test
    public void test_load() {
        StringSource source = new StringSource("Hello, world!", new Metadata().add("foo", "bar"));
        Document document = DocumentLoader.load((DocumentSource)source, (DocumentParser)new TrivialParser());
        this.assertThat(document).isEqualTo((Object)Document.from((String)"Hello, world!", (Metadata)new Metadata().add("foo", "bar")));
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> DocumentLoader.load((DocumentSource)new DocumentSource(){

            public InputStream inputStream() throws IOException {
                throw new IOException("Failed to open input stream");
            }

            public Metadata metadata() {
                return new Metadata();
            }
        }, (DocumentParser)new TrivialParser())).withMessageContaining("Failed to load document");
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> DocumentLoader.load((DocumentSource)source, inputStream -> {
            throw new RuntimeException("Failed to parse document");
        })).withMessageContaining("Failed to load document");
    }

    public static final class StringSource
    implements DocumentSource {
        private final String content;
        private final Metadata metadata;

        public StringSource(String content, Metadata metadata) {
            this.content = content;
            this.metadata = metadata;
        }

        public InputStream inputStream() {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }

        public Metadata metadata() {
            return this.metadata;
        }
    }

    public static final class TrivialParser
    implements DocumentParser {
        public Document parse(InputStream inputStream) {
            String str;
            try {
                str = new String(DocumentLoaderTest.readAllBytes(inputStream), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read input stream", e);
            }
            return Document.from((String)str);
        }
    }
}

