/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.classification;

import dev.langchain4j.classification.TextClassifier;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.segment.TextSegment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TextClassifierTest
implements WithAssertions {
    TextClassifierTest() {
    }

    @Test
    public void test() {
        CatClassifier classifier = new CatClassifier();
        this.assertThat(classifier.classify("cat fish")).containsOnly((Object[])new Categories[]{Categories.CAT, Categories.FISH});
        this.assertThat(classifier.classify(TextSegment.from((String)"dog fish"))).containsOnly((Object[])new Categories[]{Categories.DOG, Categories.FISH});
        this.assertThat(classifier.classify(Document.from((String)"dog cat"))).containsOnly((Object[])new Categories[]{Categories.CAT, Categories.DOG});
    }

    public static class CatClassifier
    implements TextClassifier<Categories> {
        public List<Categories> classify(String text) {
            HashSet<Categories> result = new HashSet<Categories>();
            if (text.contains("cat")) {
                result.add(Categories.CAT);
            }
            if (text.contains("dog")) {
                result.add(Categories.DOG);
            }
            if (text.contains("fish")) {
                result.add(Categories.FISH);
            }
            return new ArrayList<Categories>(result);
        }
    }

    public static enum Categories {
        CAT,
        DOG,
        FISH;

    }
}

