/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ToolSpecificationsTest
implements WithAssertions {
    ToolSpecificationsTest() {
    }

    @Test
    public void test_removeNulls() {
        this.assertThat(ToolSpecifications.removeNulls((JsonSchemaProperty[])new JsonSchemaProperty[]{null, JsonSchemaProperty.STRING, null})).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.STRING});
    }

    private static Method getF() throws NoSuchMethodException {
        return Wrapper.class.getMethod("f", String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, String[].class, Integer[].class, Boolean[].class, int[].class, boolean[].class, List.class, Set.class, Collection.class, List.class, Set.class, Collection.class, E.class, Object.class);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    @Test
    public void test_toolSpecificationsFrom() {
        List specs = ToolSpecifications.toolSpecificationsFrom((Object)new Wrapper());
        this.assertThat(specs).hasSize(2);
        this.assertThat(specs).extracting(ToolSpecification::name).containsExactlyInAnyOrder((Object[])new String[]{"f", "func_name"});
    }

    @Test
    public void test_toolName_memoryId() throws NoSuchMethodException {
        Method method = Wrapper.class.getMethod("g", String.class);
        ToolSpecification ts = ToolSpecifications.toolSpecificationFrom((Method)method);
        this.assertThat(ts.name()).isEqualTo("func_name");
        this.assertThat(ts.description()).isEmpty();
        this.assertThat(ts.parameters()).isNull();
    }

    @Test
    public void test_toolSpecificationFrom() throws NoSuchMethodException {
        Method method = ToolSpecificationsTest.getF();
        ToolSpecification ts = ToolSpecifications.toolSpecificationFrom((Method)method);
        this.assertThat(ts.name()).isEqualTo("f");
        this.assertThat(ts.description()).isEqualTo("line1\nline2");
        this.assertThat(ts.parameters().type()).isEqualTo("object");
        Map properties = ts.parameters().properties();
        this.assertThat(properties).hasSize(30);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)this.assertThat(properties).containsEntry((Object)"arg0", ToolSpecificationsTest.mapOf("type", "string", "description", "foo"))).containsEntry((Object)"arg1", ToolSpecificationsTest.mapOf("type", "boolean"))).containsEntry((Object)"arg2", ToolSpecificationsTest.mapOf("type", "boolean", "description", "b2"))).containsEntry((Object)"arg3", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg4", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg5", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg6", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg7", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg8", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg9", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg10", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg11", ToolSpecificationsTest.mapOf("type", "integer", "description", "biggy"))).containsEntry((Object)"arg12", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg13", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg14", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg15", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg16", ToolSpecificationsTest.mapOf("type", "number", "description", "bigger"))).containsEntry((Object)"arg17", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")))).containsEntry((Object)"arg18", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "integer")))).containsEntry((Object)"arg19", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "boolean")))).containsEntry((Object)"arg20", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "integer")))).containsEntry((Object)"arg21", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "boolean")))).containsEntry((Object)"arg22", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "integer")))).containsEntry((Object)"arg23", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "number")))).containsEntry((Object)"arg24", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")))).containsEntry((Object)"arg25", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object")))).containsEntry((Object)"arg26", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object")))).containsEntry((Object)"arg27", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object")))).containsEntry((Object)"arg29", ToolSpecificationsTest.mapOf("type", "object"));
        this.assertThat((Map)properties.get("arg28")).containsEntry((Object)"type", (Object)"string");
        this.assertThat(((Map)properties.get("arg28")).get("enum")).isEqualTo(Arrays.asList("A", "B", "C"));
        this.assertThat(ts.parameters().required()).containsExactly((Object[])new String[]{"arg0", "arg1", "arg2", "arg3", "arg4", "arg5", "arg6", "arg7", "arg8", "arg9", "arg10", "arg11", "arg12", "arg13", "arg14", "arg15", "arg16", "arg17", "arg18", "arg19", "arg20", "arg21", "arg22", "arg23", "arg24", "arg25", "arg26", "arg27", "arg28", "arg29"});
    }

    @Test
    public void test_toJsonSchemaProperties() throws NoSuchMethodException {
        Method method = ToolSpecificationsTest.getF();
        Parameter[] ps = method.getParameters();
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[0])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.STRING, JsonSchemaProperty.description((String)"foo")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[1])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.BOOLEAN});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[2])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.BOOLEAN, JsonSchemaProperty.description((String)"b2")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[3])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[4])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[5])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[6])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[7])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[8])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[9])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[10])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[11])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER, JsonSchemaProperty.description((String)"biggy")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[12])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[13])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[14])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[15])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[16])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER, JsonSchemaProperty.description((String)"bigger")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[17])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.ARRAY, JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.STRING)});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[18])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.ARRAY, JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.INTEGER)});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[19])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.ARRAY, JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.BOOLEAN)});
        ArrayList properties = new ArrayList();
        ToolSpecifications.toJsonSchemaProperties((Parameter)ps[28]).forEach(properties::add);
        this.assertThat((JsonSchemaProperty)properties.get(0)).isEqualTo((Object)JsonSchemaProperty.STRING);
        this.assertThat(((JsonSchemaProperty)properties.get(1)).value()).isEqualTo(Arrays.asList("A", "B", "C"));
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[29])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.OBJECT});
    }

    public static class Wrapper {
        @Tool(value={"line1", "line2"})
        public int f(@P(value="foo") String p0, boolean p1, @P(value="b2") Boolean p2, byte p3, Byte p4, short p5, Short p6, int p7, Integer p8, long p9, Long p10, @P(value="biggy") BigInteger p11, float p12, Float p13, double p14, Double p15, @P(value="bigger") BigDecimal p16, String[] p17, Integer[] p18, Boolean[] p19, int[] p20, boolean[] p21, List<Integer> p22, Set<BigDecimal> p23, Collection<String> p24, List p25, Set p26, Collection p27, E p28, Object p29) {
            return 42;
        }

        @Tool(name="func_name")
        public int g(@ToolMemoryId String memoryId) {
            return 42;
        }

        public int unused(int i) {
            return 42;
        }
    }

    public static enum E {
        A,
        B,
        C;

    }
}

