/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;

public enum ChatMessageType {
    SYSTEM,
    USER,
    AI,
    TOOL_EXECUTION_RESULT;


    public static Class<? extends ChatMessage> classOf(ChatMessageType type) {
        switch (type) {
            case SYSTEM: {
                return SystemMessage.class;
            }
            case USER: {
                return UserMessage.class;
            }
            case AI: {
                return AiMessage.class;
            }
            case TOOL_EXECUTION_RESULT: {
                return ToolExecutionResultMessage.class;
            }
        }
        throw Exceptions.illegalArgument("Unknown ChatMessageType: %s", new Object[]{type});
    }
}

