/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Metadata {
    private final Map<String, String> metadata;

    public Metadata() {
        this(new HashMap<String, String>());
    }

    public Metadata(Map<String, String> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        this.metadata = metadata;
    }

    public String get(String key) {
        return this.metadata.get(key);
    }

    public Metadata add(String key, Object value) {
        this.metadata.put(key, value.toString());
        return this;
    }

    public void mergeFrom(Metadata other) {
        this.metadata.putAll(other.metadata);
    }

    public Metadata copy() {
        return new Metadata(new HashMap<String, String>(this.metadata));
    }

    public Map<String, String> asMap() {
        return new HashMap<String, String>(this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    public String toString() {
        return "Metadata { metadata = " + this.metadata + " }";
    }

    public static Metadata from(String key, Object value) {
        return new Metadata().add(key, value);
    }

    public static Metadata metadata(String key, Object value) {
        return Metadata.from(key, value);
    }
}

