/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.chroma;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.chroma.AddEmbeddingsRequest;
import dev.langchain4j.store.embedding.chroma.ChromaApi;
import dev.langchain4j.store.embedding.chroma.ChromaRequestLoggingInterceptor;
import dev.langchain4j.store.embedding.chroma.ChromaResponseLoggingInterceptor;
import dev.langchain4j.store.embedding.chroma.Collection;
import dev.langchain4j.store.embedding.chroma.CreateCollectionRequest;
import dev.langchain4j.store.embedding.chroma.DeleteEmbeddingsRequest;
import dev.langchain4j.store.embedding.chroma.QueryRequest;
import dev.langchain4j.store.embedding.chroma.QueryResponse;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class ChromaClient {
    private final ChromaApi chromaApi;

    private ChromaClient(Builder builder) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().callTimeout(builder.timeout).connectTimeout(builder.timeout).readTimeout(builder.timeout).writeTimeout(builder.timeout);
        if (builder.logRequests) {
            httpClientBuilder.addInterceptor((Interceptor)new ChromaRequestLoggingInterceptor());
        }
        if (builder.logResponses) {
            httpClientBuilder.addInterceptor((Interceptor)new ChromaResponseLoggingInterceptor());
        }
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)builder.baseUrl)).client(httpClientBuilder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.chromaApi = (ChromaApi)retrofit.create(ChromaApi.class);
    }

    Collection createCollection(CreateCollectionRequest createCollectionRequest) {
        try {
            Response response = this.chromaApi.createCollection(createCollectionRequest).execute();
            if (response.isSuccessful()) {
                return (Collection)response.body();
            }
            throw ChromaClient.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Collection collection(String collectionName) {
        try {
            Response response = this.chromaApi.collection(collectionName).execute();
            if (response.isSuccessful()) {
                return (Collection)response.body();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean addEmbeddings(String collectionId, AddEmbeddingsRequest addEmbeddingsRequest) {
        try {
            Response retrofitResponse = this.chromaApi.addEmbeddings(collectionId, addEmbeddingsRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return Boolean.TRUE.equals(retrofitResponse.body());
            }
            throw ChromaClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    QueryResponse queryCollection(String collectionId, QueryRequest queryRequest) {
        try {
            Response retrofitResponse = this.chromaApi.queryCollection(collectionId, queryRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (QueryResponse)retrofitResponse.body();
            }
            throw ChromaClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteEmbeddings(String collectionId, DeleteEmbeddingsRequest deleteEmbeddingsRequest) {
        try {
            Response retrofitResponse = this.chromaApi.deleteEmbeddings(collectionId, deleteEmbeddingsRequest).execute();
            if (!retrofitResponse.isSuccessful()) {
                throw ChromaClient.toException(retrofitResponse);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteCollection(String collectionName) {
        try {
            this.chromaApi.deleteCollection(collectionName).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static class Builder {
        private String baseUrl;
        private Duration timeout;
        private boolean logRequests;
        private boolean logResponses;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ChromaClient build() {
            return new ChromaClient(this);
        }
    }
}

