/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.chroma;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.store.embedding.chroma.AddEmbeddingsRequest;
import dev.langchain4j.store.embedding.chroma.ChromaApi;
import dev.langchain4j.store.embedding.chroma.Collection;
import dev.langchain4j.store.embedding.chroma.CreateCollectionRequest;
import dev.langchain4j.store.embedding.chroma.QueryRequest;
import dev.langchain4j.store.embedding.chroma.QueryResponse;
import java.io.IOException;
import java.time.Duration;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class ChromaClient {
    private final ChromaApi chromaApi;

    ChromaClient(String baseUrl, Duration timeout) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.chromaApi = (ChromaApi)retrofit.create(ChromaApi.class);
    }

    Collection createCollection(CreateCollectionRequest createCollectionRequest) {
        try {
            Response response = this.chromaApi.createCollection(createCollectionRequest).execute();
            if (response.isSuccessful()) {
                return (Collection)response.body();
            }
            throw ChromaClient.toException(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Collection collection(String collectionName) {
        try {
            Response response = this.chromaApi.collection(collectionName).execute();
            if (response.isSuccessful()) {
                return (Collection)response.body();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean addEmbeddings(String collectionId, AddEmbeddingsRequest addEmbeddingsRequest) {
        try {
            Response retrofitResponse = this.chromaApi.addEmbeddings(collectionId, addEmbeddingsRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return Boolean.TRUE.equals(retrofitResponse.body());
            }
            throw ChromaClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    QueryResponse queryCollection(String collectionId, QueryRequest queryRequest) {
        try {
            Response retrofitResponse = this.chromaApi.queryCollection(collectionId, queryRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (QueryResponse)retrofitResponse.body();
            }
            throw ChromaClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }
}

