/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.cassandra;

import lombok.NonNull;

public class AstraDbEmbeddingConfiguration {
    @NonNull
    private String token;
    @NonNull
    private String databaseId;
    private String databaseRegion;
    @NonNull
    protected String keyspace;
    @NonNull
    protected String table;
    @NonNull
    protected Integer dimension;

    public static AstraDbEmbeddingConfigurationBuilder builder() {
        return new AstraDbEmbeddingConfigurationBuilder();
    }

    AstraDbEmbeddingConfiguration(@NonNull String token, @NonNull String databaseId, String databaseRegion, @NonNull String keyspace, @NonNull String table, @NonNull Integer dimension) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked non-null but is null");
        }
        if (keyspace == null) {
            throw new NullPointerException("keyspace is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        this.token = token;
        this.databaseId = databaseId;
        this.databaseRegion = databaseRegion;
        this.keyspace = keyspace;
        this.table = table;
        this.dimension = dimension;
    }

    @NonNull
    public String getToken() {
        return this.token;
    }

    @NonNull
    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDatabaseRegion() {
        return this.databaseRegion;
    }

    @NonNull
    public String getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public String getTable() {
        return this.table;
    }

    @NonNull
    public Integer getDimension() {
        return this.dimension;
    }

    public static class AstraDbEmbeddingConfigurationBuilder {
        private String token;
        private String databaseId;
        private String databaseRegion;
        private String keyspace;
        private String table;
        private Integer dimension;

        AstraDbEmbeddingConfigurationBuilder() {
        }

        public AstraDbEmbeddingConfigurationBuilder token(@NonNull String token) {
            if (token == null) {
                throw new NullPointerException("token is marked non-null but is null");
            }
            this.token = token;
            return this;
        }

        public AstraDbEmbeddingConfigurationBuilder databaseId(@NonNull String databaseId) {
            if (databaseId == null) {
                throw new NullPointerException("databaseId is marked non-null but is null");
            }
            this.databaseId = databaseId;
            return this;
        }

        public AstraDbEmbeddingConfigurationBuilder databaseRegion(String databaseRegion) {
            this.databaseRegion = databaseRegion;
            return this;
        }

        public AstraDbEmbeddingConfigurationBuilder keyspace(@NonNull String keyspace) {
            if (keyspace == null) {
                throw new NullPointerException("keyspace is marked non-null but is null");
            }
            this.keyspace = keyspace;
            return this;
        }

        public AstraDbEmbeddingConfigurationBuilder table(@NonNull String table) {
            if (table == null) {
                throw new NullPointerException("table is marked non-null but is null");
            }
            this.table = table;
            return this;
        }

        public AstraDbEmbeddingConfigurationBuilder dimension(@NonNull Integer dimension) {
            if (dimension == null) {
                throw new NullPointerException("dimension is marked non-null but is null");
            }
            this.dimension = dimension;
            return this;
        }

        public AstraDbEmbeddingConfiguration build() {
            return new AstraDbEmbeddingConfiguration(this.token, this.databaseId, this.databaseRegion, this.keyspace, this.table, this.dimension);
        }

        public String toString() {
            return "AstraDbEmbeddingConfiguration.AstraDbEmbeddingConfigurationBuilder(token=" + this.token + ", databaseId=" + this.databaseId + ", databaseRegion=" + this.databaseRegion + ", keyspace=" + this.keyspace + ", table=" + this.table + ", dimension=" + this.dimension + ")";
        }
    }
}

