/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.workflow.impl;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.internal.AbstractServiceBuilder;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.workflow.ConditionalAgentService;
import dev.langchain4j.agentic.workflow.impl.ConditionalPlanner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ConditionalAgentServiceImpl<T>
extends AbstractServiceBuilder<T, ConditionalAgentService<T>>
implements ConditionalAgentService<T> {
    private final List<ConditionalPlanner.ConditionalAgent> conditionalAgents = new ArrayList<ConditionalPlanner.ConditionalAgent>();

    public ConditionalAgentServiceImpl(Class<T> agentServiceClass, Method agenticMethod) {
        super(agentServiceClass, agenticMethod);
    }

    @Override
    public T build() {
        return this.build(() -> new ConditionalPlanner(this.conditionalAgents));
    }

    public static ConditionalAgentServiceImpl<UntypedAgent> builder() {
        return new ConditionalAgentServiceImpl<UntypedAgent>(UntypedAgent.class, null);
    }

    public static <T> ConditionalAgentServiceImpl<T> builder(Class<T> agentServiceClass) {
        return new ConditionalAgentServiceImpl<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass, false));
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(Object ... agents) {
        return this.subAgents(agenticScope -> true, agents);
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(Predicate<AgenticScope> condition, Object ... agents) {
        return this.subAgents((Predicate)condition, (List)AgentUtil.agentsToExecutors(agents));
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(List<AgentExecutor> agentExecutors) {
        return this.subAgents(agenticScope -> true, (List)agentExecutors);
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(Predicate<AgenticScope> condition, List<AgentExecutor> agentExecutors) {
        super.subAgents(agentExecutors);
        this.conditionalAgents.add(new ConditionalPlanner.ConditionalAgent(condition, agentExecutors.stream().map(AgentInstance.class::cast).toList()));
        return this;
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgent(Predicate<AgenticScope> condition, AgentExecutor agentExecutor) {
        this.conditionalAgents.add(new ConditionalPlanner.ConditionalAgent(condition, List.of(agentExecutor)));
        return this;
    }

    @Override
    public String serviceType() {
        return "Conditional";
    }
}

