/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.supervisor;

import dev.langchain4j.agentic.internal.AbstractServiceBuilder;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.supervisor.SupervisorAgent;
import dev.langchain4j.agentic.supervisor.SupervisorAgentService;
import dev.langchain4j.agentic.supervisor.SupervisorContextStrategy;
import dev.langchain4j.agentic.supervisor.SupervisorPlanner;
import dev.langchain4j.agentic.supervisor.SupervisorResponseStrategy;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import java.lang.reflect.Method;
import java.util.function.Function;

public class SupervisorAgentServiceImpl<T>
extends AbstractServiceBuilder<T, SupervisorAgentServiceImpl<T>>
implements SupervisorAgentService<T> {
    private ChatModel chatModel;
    private ChatMemoryProvider chatMemoryProvider;
    private int maxAgentsInvocations = 10;
    private SupervisorContextStrategy contextStrategy = SupervisorContextStrategy.CHAT_MEMORY;
    private SupervisorResponseStrategy responseStrategy = SupervisorResponseStrategy.LAST;
    private Function<AgenticScope, String> requestGenerator;
    private String supervisorContext;

    public SupervisorAgentServiceImpl(Class<T> agentServiceClass, Method agenticMethod) {
        super(agentServiceClass, agenticMethod);
    }

    @Override
    public T build() {
        if (this.supervisorContext != null) {
            this.beforeCall(agenticScope -> {
                if (!agenticScope.hasState("supervisorContext")) {
                    agenticScope.writeState("supervisorContext", this.supervisorContext);
                }
            });
        }
        return this.build(() -> new SupervisorPlanner(this.chatModel, this.chatMemoryProvider, this.maxAgentsInvocations, this.contextStrategy, this.responseStrategy, this.requestGenerator, this.outputKey, this.output));
    }

    public static SupervisorAgentService<SupervisorAgent> builder() {
        return new SupervisorAgentServiceImpl<SupervisorAgent>(SupervisorAgent.class, null);
    }

    public static <T> SupervisorAgentService<T> builder(Class<T> agentServiceClass) {
        return new SupervisorAgentServiceImpl<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass, false));
    }

    @Override
    public SupervisorAgentServiceImpl<T> chatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> chatMemoryProvider(ChatMemoryProvider chatMemoryProvider) {
        this.chatMemoryProvider = chatMemoryProvider;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> requestGenerator(Function<AgenticScope, String> requestGenerator) {
        this.requestGenerator = requestGenerator;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> contextGenerationStrategy(SupervisorContextStrategy contextStrategy) {
        this.contextStrategy = contextStrategy;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> responseStrategy(SupervisorResponseStrategy responseStrategy) {
        this.responseStrategy = responseStrategy;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> supervisorContext(String supervisorContext) {
        this.supervisorContext = supervisorContext;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> maxAgentsInvocations(int maxAgentsInvocations) {
        this.maxAgentsInvocations = maxAgentsInvocations;
        return this;
    }

    @Override
    public String serviceType() {
        return "Supervisor";
    }
}

